define(
    'bitbucket/internal/bbui/image-differ/image-differ',
    ['exports', 'module', 'jquery', 'lodash', 'resemble', '../widget', './image-differ-mode', './image-differ-modes'],
    function (exports, module, _jquery, _lodash, _resemble, _widget, _imageDifferMode, _imageDifferModes) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _resemble2 = _interopRequireDefault(_resemble);

        var _Widget2 = _interopRequireDefault(_widget);

        var _DifferMode = _interopRequireDefault(_imageDifferMode);

        var _ImageDifferModes = _interopRequireDefault(_imageDifferModes);

        var RESIZE_DEBOUNCE = 200;

        /**
         * Create an ImageDiffer instance in the provided $container. This instance must eventually be `.init()`ed
         *
         * @param {jQuery|HTMLElement} $container where to place the differ.
         * @constructor
         */

        var ImageDiffer = (function (_Widget) {
            _inherits(ImageDiffer, _Widget);

            /**
             * @param {jQuery|HtmlElement} container - The container to use for this ImageDiffer
             */

            function ImageDiffer(container) {
                _classCallCheck(this, ImageDiffer);

                _get(Object.getPrototypeOf(ImageDiffer.prototype), 'constructor', this).call(this);
                this._$container = (0, _$['default'])(container);
            }

            /**
             * Calculate the natural size of an image.
             *
             * @param {jQuery|HtmlElement} image - The image whose size will be calculated
             * @returns {Promise.<{width:number, height:number}>}
             */

            /**
             * Initialize the instance. This expects two images to be found in the $container and assumes the first
             * is the "old" revision and the second is the "new" revision. This function will retrieve information about the
             * images like width and height.
             *
             * @returns {Promise} promise that is resolved when the ImageDiffer is fully initialized.
             */

            _createClass(ImageDiffer, [{
                key: 'init',
                value: function init() {
                    var _this = this;

                    var $imgs = this._$imgs = this._$container.find('img');

                    this._$sinceImg = $imgs.eq(0);
                    this._$untilImg = $imgs.eq(1);

                    this._$untilRevision = this._$untilImg.parent();
                    this._$sinceRevision = this._$sinceImg.parent();
                    this._$revisions = this._$untilRevision.add(this._$sinceRevision);

                    this._$untilRevisionLabel = this._$untilRevision.find('h5');
                    this._$sinceRevisionLabel = this._$sinceRevision.find('h5');
                    this._setupDiffModes();

                    this.setMode(_ImageDifferModes['default'].TWO_UP);

                    var initialized = _$['default'].Deferred();

                    var defaultModes = [_ImageDifferModes['default'].TWO_UP];
                    // Extra modes is all available modes except two-up
                    var extraModes = _2['default'].chain(_ImageDifferModes['default']).values().difference(defaultModes).value();

                    _$['default'].when(calculateImageNaturalSize(this._$sinceImg), calculateImageNaturalSize(this._$untilImg)).done(function (oldSize, newSize) {
                        var sameDimensions = oldSize.width === newSize.width && oldSize.height === newSize.height;
                        var enableExtraModes = sameDimensions && oldSize.width > 0;
                        _this.enabledModes = enableExtraModes ? defaultModes.concat(extraModes) : defaultModes;
                        initialized.resolve(_this.enabledModes);
                    }).fail(function () {
                        initialized.reject();
                    });

                    return initialized;
                }

                /**
                 * destroy this instance and reclaim memory. It cannot be used after this.
                 */
            }, {
                key: 'destroy',
                value: function destroy() {
                    if (this.modes && this._mode) {
                        this.modes[this._mode].destroy();
                    }
                    this._mode = null;
                }

                /**
                 * Set the mode to be used to diff these images.
                 *
                 * @param {string} mode - which diffing {@link ImageDifferModes mode} to use
                 */
            }, {
                key: 'setMode',
                value: function setMode(mode) {
                    if (this._mode !== mode) {
                        this._onDiffModeChanged(mode, this._mode);
                        this._mode = mode;
                    }
                }

                /**
                 * When the diff mode changes trigger a mode change event and update the container class
                 *
                 * @param {string} newMode - new {@link ImageDifferModes mode}
                 * @param {string} oldMode - old {@link ImageDifferModes mode}
                 * @private
                 */
            }, {
                key: '_onDiffModeChanged',
                value: function _onDiffModeChanged(newMode, oldMode) {

                    this._$container.removeClass(_2['default'].values(_ImageDifferModes['default']).join(' ')).addClass(newMode);

                    if (oldMode) {
                        this.modes[oldMode].destroy();
                    }
                    if (newMode) {
                        this.modes[newMode].setup();
                    }

                    this.trigger('modeChanged', {
                        newMode: newMode,
                        oldMode: oldMode
                    });
                }

                /**
                 * Sets up the diff modes. For each diff mode a DiffMode is created that has a setup and destroy method
                 * that can be used to perform the setup/destroy when switching between modes.
                 *
                 * @private
                 */
            }, {
                key: '_setupDiffModes',
                value: function _setupDiffModes() {
                    var _this2 = this;

                    this.modes = {};

                    var _setSplitDiffElementProperties = function _setSplitDiffElementProperties($untilRevisionImageContainer, $splitContainer, naturalImageSize) {

                        // determine the chain of element widths that will allow us to fit our imgs within the content frame:
                        // max width of .binary-container
                        var maxBinaryContainerWidth = getMaxWidthToFit(_this2._$container, _this2._$container.parent().width());
                        // max width of .split-container
                        var maxSplitContainerWidth = getMaxWidthToFit($splitContainer, maxBinaryContainerWidth);
                        // max width of each .binary
                        var maxRevisionWidth = getMaxWidthToFit(_this2._$sinceRevision, maxSplitContainerWidth);
                        // max width of each image
                        var maxImgWidth = getMaxWidthToFit(_this2._$sinceImg, maxRevisionWidth);

                        // set the imgs to their natural width explicitly, or else to the max width if they won't fit.
                        var imageWidth = Math.min(naturalImageSize.width, maxImgWidth);
                        _this2._$imgs.width(imageWidth);
                        // set a proportional height
                        _this2._$imgs.height(Math.floor(imageWidth / naturalImageSize.width * naturalImageSize.height));

                        // set the image container height to perfectly fit the images (they have a border, so we can't just use the same value).
                        $untilRevisionImageContainer.height(_this2._$imgs.outerHeight(true));

                        // now that we have the width of the images, work back up so we can set an explicit width on .binary
                        var revisionWidth = imageWidth + (maxRevisionWidth - maxImgWidth);
                        _this2._$revisions.width(revisionWidth);
                        // shift the entire .until-revision container to the left by the same distance as the width of the image, so that the two .binary containers overlap
                        _this2._$untilRevision.css('margin-left', -revisionWidth);
                    };

                    /**
                     * Setup and Destroy for TWO_UP are noops
                     */
                    this.modes[_ImageDifferModes['default'].TWO_UP] = new _DifferMode['default']();

                    /**
                     * Setup and Destroy methods for BLEND mode
                     */
                    this.modes[_ImageDifferModes['default'].BLEND] = new _DifferMode['default'](

                    /**
                     * Setup for BLEND mode
                     */
                    function () {
                        // add in the slider
                        var $opacitySliderContainer = (0, _$['default'])(bitbucket.internal.component.imageDiffer.opacitySlider());
                        _this2._$container.children('.since-revision').before($opacitySliderContainer);

                        $opacitySliderContainer.on('input change', 'input[type="range"]', function (e) {
                            _this2._$untilImg.css('opacity', parseFloat((0, _$['default'])(e.target).val()));
                        });
                    },

                    /**
                     * Destroy for BLEND mode
                     */
                    function () {
                        var $opacitySliderContainer = _this2._$container.children('.opacity-slider-container');

                        $opacitySliderContainer.off('input change');
                        $opacitySliderContainer.remove();
                        _this2._$untilImg.css('opacity', '');
                    });

                    /**
                     * Setup and Destroy methods for SPLIT mode
                     */
                    this.modes[_ImageDifferModes['default'].SPLIT] = new _DifferMode['default'](

                    /**
                     * Setup for SPLIT mode
                     */
                    function () {
                        calculateImageNaturalSize(_this2._$imgs).done(function (naturalImageSize) {

                            _this2._$untilImg.wrap(bitbucket.internal.component.imageDiffer.imageContainer());
                            _this2._$revisions.wrapAll(bitbucket.internal.component.imageDiffer.splitContainer());

                            _this2._$untilRevisionImageContainer = _this2._$untilImg.parent();
                            _this2._$splitContainer = _this2._$container.find('.split-container');

                            var maxImageContainerWidth = undefined;
                            var setMaxImageContainerWidth = function setMaxImageContainerWidth() {
                                _setSplitDiffElementProperties(_this2._$untilRevisionImageContainer, _this2._$splitContainer, naturalImageSize);
                                maxImageContainerWidth = _this2._$sinceImg.outerWidth(true);
                            };

                            _this2._onResize = _2['default'].debounce(setMaxImageContainerWidth, RESIZE_DEBOUNCE);

                            (0, _$['default'])(window).on('resize', _this2._onResize);
                            setMaxImageContainerWidth();

                            var MIN_IMAGE_WIDTH_THRESHOLD = 50;
                            var OFFSET_IMAGE_WIDTH_THRESHOLD = 100;

                            if (naturalImageSize.width < MIN_IMAGE_WIDTH_THRESHOLD) {
                                // If the image width is < 50px, that offset based on image width is not going to be sufficient
                                // to prevent overlap, so fix it at -50px
                                _this2._$untilRevisionLabel.css('margin-left', '-' + MIN_IMAGE_WIDTH_THRESHOLD + 'px');
                                _this2._$sinceRevisionLabel.css('margin-right', '-' + MIN_IMAGE_WIDTH_THRESHOLD + 'px');
                            } else if (naturalImageSize.width < OFFSET_IMAGE_WIDTH_THRESHOLD) {
                                // If the image width is < 100px, offset the since and until (old/new) labels by the same px
                                // distance using negative margins so they sit outside of the .binary container
                                _this2._$untilRevisionLabel.css('margin-left', -naturalImageSize.width);
                                _this2._$sinceRevisionLabel.css('margin-right', -naturalImageSize.width);
                            }

                            var onMove = function onMove(e) {
                                _this2._$untilRevisionImageContainer.css('width', Math.min(e.pageX - e.data.offset.left, maxImageContainerWidth));
                            };

                            _this2._$splitContainer.hover(function () {
                                _this2._$revisions.on('mousemove', { offset: _this2._$untilRevision.offset() }, onMove);
                            }, function () {
                                _this2._$revisions.off('mousemove', onMove);
                            });
                        });
                    },

                    /**
                     * Destroy for SPLIT mode
                     */
                    function () {
                        _this2._$imgs.css({
                            width: '',
                            height: ''
                        });
                        _this2._$revisions.css('width', '');
                        _this2._$untilRevision.css('margin-left', '');
                        _this2._$untilRevisionLabel.add(_this2._$sinceRevisionLabel).css({
                            marginLeft: '',
                            marginRight: ''
                        });

                        _this2._$untilImg.unwrap();
                        _this2._$untilRevisionImageContainer.remove(); // cleanup events
                        delete _this2._$untilRevisionImageContainer;

                        _this2._$revisions.unwrap();
                        _this2._$splitContainer.remove(); // cleanup events
                        delete _this2._$splitContainer;

                        if (_this2._onResize) {
                            (0, _$['default'])(window).off('resize', _this2._onResize);
                            delete _this2._onResize;
                        }
                    });

                    /**
                     * Setup and Destroy for PIXEL_DIFF mode
                     */
                    this.modes[_ImageDifferModes['default'].PIXEL_DIFF] = new _DifferMode['default'](

                    /**
                     * Setup for PIXEL_DIFF mode
                     */
                    function () {
                        _this2._$revisions.wrapAll(bitbucket.internal.component.imageDiffer.pixelDiffContainer());
                        _this2._$pixelDiffContainer = _this2._$container.find('.pixeldiff-container');

                        if (_this2._$pixelDiffImg) {
                            _this2._$pixelDiffContainer.append(_this2._$pixelDiffImg);
                            return;
                        }

                        var $spinner = (0, _$['default'])(bitbucket.internal.component.imageDiffer.spinner());
                        _this2._$pixelDiffContainer.append($spinner);
                        $spinner.spin('large');

                        _2['default'].defer(function () {
                            var sincePromise = getImageData(_this2._$sinceImg);
                            var untilPromise = getImageData(_this2._$untilImg);

                            _$['default'].when(sincePromise, untilPromise).then(function (sinceImgData, untilImgData) {
                                _resemble2['default'].outputSettings({
                                    errorColor: {
                                        red: 208,
                                        green: 68,
                                        blue: 55
                                    },
                                    errorType: 'flat',
                                    transparency: 0.1 });

                                // setting to 0 is broken: https://github.com/Huddle/Resemble.js/issues/26
                                var comparePromise = _$['default'].Deferred();
                                (0, _resemble2['default'])(sinceImgData).compareTo(untilImgData).onComplete(function (data) {
                                    return comparePromise.resolve(data);
                                });

                                return comparePromise;
                            }).done(function (data) {
                                _this2._$pixelDiffImg = (0, _$['default'])(bitbucket.internal.component.imageDiffer.pixelDiffImage({ imageSrc: data.getImageDataUrl() }));
                                _this2._$pixelDiffContainer.append(_this2._$pixelDiffImg);
                            }).always(function () {
                                $spinner.remove();
                            });
                        });
                    },

                    /**
                     * Destroy for PIXEL_DIFF mode
                     */
                    function () {
                        if (_this2._$pixelDiffImg) {
                            _this2._$pixelDiffImg.remove(); // Removing from DOM but keeping generated image for perf reasons
                        }

                        _this2._$revisions.unwrap();
                        _this2._$pixelDiffContainer.remove();
                        delete _this2._$pixelDiffContainer;
                    });
                }
            }]);

            return ImageDiffer;
        })(_Widget2['default']);

        function calculateImageNaturalSize(image) {
            var $image = (0, _$['default'])(image);
            if ($image.data('natural-size')) {
                return _$['default'].Deferred().resolve($image.data('natural-size'));
            }

            // user the naturalWidth and naturalHeight properties if it's available
            if (image.naturalWidth) {
                var size = {
                    width: image.naturalWidth,
                    height: image.naturalHeight
                };
                $image.data('natural-size', size);
                return _$['default'].Deferred().resolve(size);
            }

            // create an image object in memory, wait till it's loaded and get its dimensions
            var newImg = new Image();
            var promise = _$['default'].Deferred();
            var onComplete = _2['default'].once(function () {
                var size = {
                    width: newImg.width,
                    height: newImg.height
                };
                $image.data('natural-size', size);
                promise.resolve(size);
            });

            newImg.onload = onComplete;
            newImg.src = $image.attr('src');
            if (newImg.complete) {
                onComplete();
            }
            return promise;
        }

        /**
         * Get the maximum width of a given element by subtracting the box model things from it
         *
         * @param {jQuery} $el - The element to measure
         * @param {number} parentWidth - The width to fit into
         * @returns {number}
         */
        function getMaxWidthToFit($el, parentWidth) {

            var marginBorderPadding = $el.data('margin_border_padding');
            if (marginBorderPadding == null) {
                marginBorderPadding = $el.outerWidth(true) - $el.width();
                $el.data('margin_border_padding', marginBorderPadding);
            }

            return parentWidth - marginBorderPadding;
        }

        /**
         * Get the image data for a given image tag
         *
         * @param {jQuery} $image - The image element to get data from
         * @returns {*|Promise.<{width: number, height: number}>|Promise|!Promise.<RESULT>}
         */
        function getImageData($image) {
            var canvas = document.createElement('canvas');
            var ctx = canvas.getContext('2d');

            return calculateImageNaturalSize($image).then(function (size) {
                canvas.height = size.height;
                canvas.width = size.width;
                ctx.drawImage($image[0], 0, 0);
                return ctx.getImageData(0, 0, canvas.width, canvas.height);
            });
        }

        module.exports = ImageDiffer;
    }
);