define(
    'bitbucket/internal/bbui/branch-from-to',
    ['exports', 'module', 'react', 'aui', 'classnames', 'react-dom', './aui-react/avatar'],
    function (exports, module, _react, _aui, _classnames, _reactDom, _auiReactAvatar) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _AJS = _interopRequireDefault(_aui);

        var _classNames = _interopRequireDefault(_classnames);

        var propTypes = {
            fromRef: _react.PropTypes.object.isRequired,
            toRef: _react.PropTypes.object.isRequired
        };

        var BranchFromTo = (function (_Component) {
            _inherits(BranchFromTo, _Component);

            function BranchFromTo() {
                _classCallCheck(this, BranchFromTo);

                _get(Object.getPrototypeOf(BranchFromTo.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(BranchFromTo, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    _AJS['default'].$('.ref-name', node).tooltip();
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    _AJS['default'].$('.ref-name', node).tooltip('destroy');
                }
            }, {
                key: 'refItem',
                value: function refItem(ref, type, sameProject, sameRepo) {
                    var showProject = !sameProject;
                    var showRepo = sameProject && !sameRepo;
                    var avatar = this.projectAvatar(ref, showProject);

                    return _React['default'].createElement(
                        'div',
                        { className: (0, _classNames['default'])('ref-name', 'ref-name-' + type, { 'with-avatar': avatar }), title: this.refTitle(ref) },
                        avatar,
                        this.displayTitle(ref, showRepo)
                    );
                }
            }, {
                key: 'projectAvatar',
                value: function projectAvatar(ref, differentProject) {
                    if (differentProject) {
                        return _React['default'].createElement(
                            'span',
                            { className: 'avatar-to-project avatar-ref-project' },
                            _React['default'].createElement(_auiReactAvatar.ProjectAvatar, {
                                size: 'xsmall',
                                project: ref.repository.project,
                                tagName: 'span'
                            })
                        );
                    }
                }
            }, {
                key: 'displayTitle',
                value: function displayTitle(ref, showRepo) {
                    if (showRepo) {
                        return _React['default'].createElement(
                            'span',
                            null,
                            _React['default'].createElement(
                                'span',
                                { className: 'repo-name' },
                                ref.repository.name
                            ),
                            _React['default'].createElement('span', { className: 'repo-name-icon' }),
                            _React['default'].createElement(
                                'span',
                                { className: 'branch-name' },
                                ref.display_id
                            )
                        );
                    }
                    return _React['default'].createElement(
                        'span',
                        { className: 'branch-name' },
                        ref.display_id
                    );
                }
            }, {
                key: 'refTitle',
                value: function refTitle(ref) {
                    return ref.repository.project.name + ' / ' + ref.repository.name + ' / ' + ref.display_id;
                }
            }, {
                key: 'render',
                value: function render() {
                    var _props = this.props;
                    var fromRef = _props.fromRef;
                    var toRef = _props.toRef;

                    var sameProject = fromRef.repository.project.id === toRef.repository.project.id;
                    var sameRepo = fromRef.repository.id === toRef.repository.id;

                    return _React['default'].createElement(
                        'div',
                        { className: 'branch-from-to' },
                        this.refItem(fromRef, 'from', sameProject, sameRepo),
                        _React['default'].createElement(
                            'div',
                            { className: 'aui-icon aui-icon-small aui-iconfont-devtools-arrow-right arrow' },
                            'to'
                        ),
                        this.refItem(toRef, 'to', sameProject, sameRepo)
                    );
                }
            }]);

            return BranchFromTo;
        })(_react.Component);

        BranchFromTo.propTypes = propTypes;

        module.exports = BranchFromTo;
    }
);