define(
    'bitbucket/internal/bbui/reviewer-status',
    ['exports', 'module', 'aui', 'lodash', 'react', './models'],
    function (exports, module, _aui, _lodash, _react, _models) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _AJS = _interopRequireDefault(_aui);

        var _2 = _interopRequireDefault(_lodash);

        var _React = _interopRequireDefault(_react);

        var propTypes = {
            onStatusClick: _react.PropTypes.func.isRequired,
            status: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState))
        };

        var titles = {
            'approve': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.approve'),
            'approve-deselect': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.approve.deselect'),
            'needs-work': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.needs.work'),
            'needs-work-deselect': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.needs.work.deselect')
        };

        var titlesWithLineBreaks = {
            'approve': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.approve.html'),
            'approve-deselect': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.approve.deselect.html'),
            'needs-work': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.needs.work.html'),
            'needs-work-deselect': _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.needs.work.deselect.html')
        };

        var ReviewerStatus = function ReviewerStatus(props) {
            function makeStatus(status, cssClass) {
                var isPressed = props.status === status;
                return _React['default'].createElement(
                    'button',
                    { className: 'aui-button ' + cssClass, 'aria-pressed': isPressed,
                        title: titlesWithLineBreaks[cssClass + (isPressed ? '-deselect' : '')],
                        onClick: function () {
                            return props.onStatusClick({ newStatus: isPressed ? _models.ApprovalState.UNAPPROVED : status });
                        },
                        ref: function (el) {
                            return _AJS['default'].$(el).tooltip({
                                html: true
                            });
                        }
                    },
                    _React['default'].createElement(
                        'span',
                        null,
                        titles[cssClass + (isPressed ? '-deselect' : '')]
                    )
                );
            }

            return _React['default'].createElement(
                'div',
                { className: 'aui-buttons reviewer-status-selector', 'data-status': props.status },
                makeStatus(_models.ApprovalState.NEEDS_WORK, 'needs-work'),
                makeStatus(_models.ApprovalState.APPROVED, 'approve')
            );
        };
        ReviewerStatus.propTypes = propTypes;

        module.exports = ReviewerStatus;
    }
);