define(
    'bitbucket/internal/bbui/pull-request-header/components/reopen-button',
    ['exports', 'module', 'react', 'react-dom', './spinner'],
    function (exports, module, _react, _reactDom, _spinner) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _Spinner = _interopRequireDefault(_spinner);

        var defaultProps = {
            enabled: true
        };

        var propTypes = {
            onReOpenClick: _react.PropTypes.func.isRequired,
            enabled: _react.PropTypes.bool
        };

        var ReOpenButton = (function (_Component) {
            _inherits(ReOpenButton, _Component);

            function ReOpenButton(props) {
                _classCallCheck(this, ReOpenButton);

                _get(Object.getPrototypeOf(ReOpenButton.prototype), 'constructor', this).call(this, props);

                this.state = {
                    enabled: props.enabled
                };
            }

            _createClass(ReOpenButton, [{
                key: 'componentWillUpdate',
                value: function componentWillUpdate(nextProps, nextState) {
                    if (!nextState.enabled) {
                        // the spinner will be shown, measure the button and set its width.
                        var node = (0, _reactDom.findDOMNode)(this);
                        // use getBoundingClientRect to get the full width of the
                        // button (including borders)
                        var rect = node.getBoundingClientRect();
                        node.style.width = rect.right - rect.left + 'px';
                    }
                }
            }, {
                key: 'onClick',
                value: function onClick() {
                    var _this = this;

                    this.props.onReOpenClick().fail(function () {
                        _this.setState({ enabled: true });
                    });

                    this.setState({ enabled: false });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var title = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen.tooltip');
                    var content = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen');

                    if (!this.state.enabled) {
                        content = _React['default'].createElement(_Spinner['default'], null);
                    }
                    return _React['default'].createElement(
                        'button',
                        {
                            onClick: function () {
                                return _this2.onClick();
                            },
                            className: 'aui-button aui-button-primary reopen-button',
                            'aria-disabled': !this.state.enabled,
                            title: title
                        },
                        content
                    );
                }
            }]);

            return ReOpenButton;
        })(_react.Component);

        ReOpenButton.propTypes = propTypes;
        ReOpenButton.defaultProps = defaultProps;

        module.exports = ReOpenButton;
    }
);