define(
    'bitbucket/internal/bbui/pull-request-header/components/pull-request-more',
    ['exports', 'module', 'react', 'classnames', 'jquery', 'lodash', 'bitbucket/internal/impl/web-fragments', '../../aui-react/component', '../../models'],
    function (exports, module, _react, _classnames, _jquery, _lodash, _bitbucketInternalImplWebFragments, _auiReactComponent, _models) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _webFragments = _interopRequireDefault(_bitbucketInternalImplWebFragments);

        var _AUIComponent = _interopRequireDefault(_auiReactComponent);

        var propTypes = {
            onMoreAction: _react.PropTypes.func.isRequired,
            isWatching: _react.PropTypes.bool.isRequired,
            conditions: _react.PropTypes.objectOf(_react.PropTypes.bool).isRequired,
            pullRequest: _react.PropTypes.object.isRequired
        };

        var PullRequestMore = (function (_Component) {
            _inherits(PullRequestMore, _Component);

            function PullRequestMore() {
                _classCallCheck(this, PullRequestMore);

                _get(Object.getPrototypeOf(PullRequestMore.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(PullRequestMore, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    // hide the more menu when it's supposed to be closed
                    // For whatever reason (probably a react / non-react conflict) the more menu doesn't hide itself properly
                    // and instead hangs around too long. We force it to hide here.
                    (0, _$['default'])("#pull-request-header-more").on("aui-dropdown2-hide", function (event) {
                        (0, _$['default'])(event.target).css('display', 'none');
                    });
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    (0, _$['default'])("#pull-request-header-more").off("aui-dropdown2-hide");
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var editMenuItem = undefined;
                    var declineMenuItem = undefined;
                    var pullRequestIsOpen = this.props.pullRequest.state === _models.PullRequestState.OPEN;

                    var addonActions = _webFragments['default'].getWebItems('bitbucket.pullrequest.action', { pullRequest: this.props.pullRequest });
                    var deprecatedActions = _2['default'].flatten(_webFragments['default'].getWebSections('bitbucket.internal.pullrequest.toolbar.deprecated').map(function (section) {
                        return _webFragments['default'].getWebItems('bitbucket.internal.pullrequest.toolbar.deprecated/' + section.key);
                    }));

                    if (this.props.conditions.canEdit && pullRequestIsOpen) {
                        editMenuItem = _React['default'].createElement(
                            'li',
                            null,
                            _React['default'].createElement(
                                'button',
                                { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'edit' },
                                AJS.I18n.getText('bitbucket.component.pull.request.edit')
                            )
                        );
                    }
                    if (this.props.conditions.canDecline && pullRequestIsOpen) {
                        declineMenuItem = _React['default'].createElement(
                            'li',
                            null,
                            _React['default'].createElement(
                                'button',
                                { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'decline' },
                                AJS.I18n.getText('bitbucket.component.pull.request.decline')
                            )
                        );
                    }
                    return _React['default'].createElement(
                        'div',
                        null,
                        _React['default'].createElement(
                            'button',
                            {
                                className: 'pull-request-more-trigger aui-button aui-button-subtle aui-dropdown2-trigger aui-dropdown2-trigger-arrowless',
                                'aria-haspopup': 'true',
                                'aria-owns': 'pull-request-header-more'
                            },
                            _React['default'].createElement(
                                'span',
                                { className: 'aui-icon aui-icon-small aui-iconfont-more' },
                                AJS.I18n.getText('bitbucket.component.pull.request.more')
                            )
                        ),
                        _React['default'].createElement(
                            _AUIComponent['default'],
                            { id: 'pull-request-header-more', markup: '<div class="aui-style-default aui-dropdown2"></div>' },
                            _React['default'].createElement(
                                'ul',
                                { className: 'aui-list-truncate', onClick: function (e) {
                                        return _this.props.onMoreAction(e.target.dataset.action);
                                    } },
                                editMenuItem,
                                declineMenuItem,
                                _React['default'].createElement(
                                    'li',
                                    null,
                                    _React['default'].createElement(
                                        'button',
                                        { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'watch' },
                                        this.props.isWatching ? AJS.I18n.getText('bitbucket.component.pull.request.unwatch') : AJS.I18n.getText('bitbucket.component.pull.request.watch')
                                    )
                                ),
                                addonActions.concat(deprecatedActions).map(function (webItem) {
                                    return _React['default'].createElement(
                                        'li',
                                        { key: webItem.completeModuleKey || webItem.key },
                                        webItem.url ? _React['default'].createElement(
                                            'button',
                                            { className: (0, _classNames['default'])("aui-button aui-button-link", webItem.cssClass),
                                                role: 'menuitem', id: webItem.id, title: webItem.tooltip
                                            },
                                            webItem.text
                                        ) : _React['default'].createElement(
                                            'a',
                                            { href: webItem.url, className: webItem.cssClass, id: webItem.id, title: webItem.tooltip },
                                            webItem.text
                                        )
                                    );
                                })
                            )
                        )
                    );
                }
            }]);

            return PullRequestMore;
        })(_react.Component);

        PullRequestMore.propTypes = propTypes;

        module.exports = PullRequestMore;
    }
);
/* TODO:
 - plugin points
*/