define(
    'bitbucket/internal/bbui/image-differ/image-differ-toolbar',
    ['exports', 'module', 'jquery', 'lodash', '../widget', './image-differ-modes'],
    function (exports, module, _jquery, _lodash, _widget, _imageDifferModes) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _Widget2 = _interopRequireDefault(_widget);

        var _ImageDifferModes = _interopRequireDefault(_imageDifferModes);

        /**
         * A toolbar containing controls for diffing two image files.
         *
         * When the constructor is called, the toolbar will be in an initial,
         * partially disabled state where only the two-up mode is available.
         * `.init()` must eventually also be called on the toolbar.
         *
         * @param {jQuery|HTMLElement} toolbarEl - the toolbar generated from calling
         *        Soy template bitbucket.internal.component.imageDiffer.toolbar.main or HTML markup
         * @constructor ImageDiffToolbar
         */

        var ImageDiffToolbar = (function (_Widget) {
            _inherits(ImageDiffToolbar, _Widget);

            function ImageDiffToolbar(toolbarEl) {
                _classCallCheck(this, ImageDiffToolbar);

                _get(Object.getPrototypeOf(ImageDiffToolbar.prototype), 'constructor', this).call(this);
                this._$toolbar = (0, _$['default'])(toolbarEl);
                this._$toggle = this._$toolbar.find('.image-differ-toggle');
            }

            /**
             * Initialize the toolbar and enable all diffing modes, if appropriate.
             *
             * @param {Array.<string>} enabledModes - an array of enabled {@link ImageDifferModes}
             */

            _createClass(ImageDiffToolbar, [{
                key: 'init',
                value: function init(enabledModes) {
                    var _this = this;

                    var buttons = {};
                    _2['default'].values(_ImageDifferModes['default']).forEach(function (mode) {
                        // Check all available modes against the enabled modes and
                        // set the button state for it accordingly.
                        var isModeEnabled = enabledModes.indexOf(mode) !== -1;
                        var $button = _this._$toggle.find('.image-differ-' + mode);
                        $button.attr('aria-disabled', !isModeEnabled).prop('disabled', !isModeEnabled);

                        if (!isModeEnabled) {
                            return;
                        }
                        if ($button.attr('data-enabled-title')) {
                            $button.attr('data-disabled-title', $button.attr('title'));
                        }

                        $button.attr('data-mode', mode);
                        $button.attr('title', $button.attr('data-enabled-title'));
                        buttons[mode] = $button;
                    });

                    /* TODO: Remove when dropping IE9 Support in Stash */
                    if (enabledModes.indexOf(_ImageDifferModes['default'].BLEND) !== -1) {
                        // don't show blend mode for old browsers (<= IE9)
                        var supportsRangeInput = (function () {
                            var el = document.createElement('input');
                            el.setAttribute('type', 'range');
                            return el.type === 'range';
                        })();
                        var $button = buttons[_ImageDifferModes['default'].BLEND];
                        $button.attr('aria-disabled', !supportsRangeInput).prop('disabled', !supportsRangeInput);
                        if (!supportsRangeInput) {
                            $button.attr('title', $button.attr('data-disabled-title'));
                        }
                    }

                    /**
                     * Trigger a local modeChanged event and set the mode
                     * @param {string} newMode - The new mode
                     */
                    var changeMode = function changeMode(newMode) {
                        var oldMode = _this._mode;
                        _this._mode = newMode;
                        _this.trigger('modeChanged', {
                            newMode: newMode,
                            oldMode: oldMode
                        });
                    };

                    var $modeListButtons = this._$toggle.find('.aui-button');

                    $modeListButtons.on('click', function (e) {
                        e.preventDefault();
                        var $el = (0, _$['default'])(e.target);
                        if ($el.attr('aria-disabled') !== 'true' && $el.attr('aria-pressed') !== 'true') {
                            var newMode = $el.attr('data-mode');
                            $modeListButtons.attr('aria-pressed', 'false');
                            $el.attr('aria-pressed', 'true');
                            changeMode(newMode);
                        }
                    }).tooltip({ gravity: 's' });

                    changeMode(_ImageDifferModes['default'].TWO_UP);
                }

                /**
                 * Can be called to retrieve the currently selected diffing mode represented by the toolbar at any time.
                 *
                 * @returns {string} the currently selected {@link ImageDifferModes mode}
                 */
            }, {
                key: 'getMode',
                value: function getMode() {
                    return this._mode;
                }

                /**
                 * destroy this toolbar instance and remove it from the DOM. Once destroyed, it cannot be reused.
                 */
            }, {
                key: 'destroy',
                value: function destroy() {
                    if (this._$toolbar) {
                        this._$toolbar.remove();
                        this._$toolbar = null;
                    }
                    this._$toggle = null;
                }
            }]);

            return ImageDiffToolbar;
        })(_Widget2['default']);

        module.exports = ImageDiffToolbar;
    }
);