define(
  'bitbucket/internal/bbui/image-differ/image-differ-mode',
  ["exports", "module"],
  function (exports, module) {
    /**
     * Image Differ Mode.
     * Use this class to create an Image Differ Mode instance with a
     * setup and destroy method. Used for switching between modes.
     */
    "use strict";

    var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

    function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

    var ImageDifferMode = (function () {

      /**
       * @param {Function} [setup] - A setup method for the mode
       * @param {Function} [destroy] - A destroy method for the mode where it cleans up after itself
       */

      function ImageDifferMode(setup, destroy) {
        _classCallCheck(this, ImageDifferMode);

        if (setup) {
          this.setup = setup;
        }
        if (destroy) {
          this.destroy = destroy;
        }
      }

      /**
       * A setup method for the mode
       */

      _createClass(ImageDifferMode, [{
        key: "setup",
        value: function setup() {}

        /**
         * A destroy method for the mode where it cleans up after itself
         */
      }, {
        key: "destroy",
        value: function destroy() {}
      }]);

      return ImageDifferMode;
    })();

    module.exports = ImageDifferMode;
  }
);