define(
    'bitbucket/internal/bbui/codesearch',
    ['exports', 'module', 'jquery', 'lodash', 'bitbucket/internal/impl/urls', './history', './codesearch/internal/analytics', './codesearch/internal/search'],
    function (exports, module, _jquery, _lodash, _bitbucketInternalImplUrls, _history, _internalAnalytics, _internalSearch) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _Urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _history2 = _interopRequireDefault(_history);

        var _Analytics = _interopRequireDefault(_internalAnalytics);

        var searchResults = undefined;

        var CONTEXT_RE = /(project:\S*)|(repo:\S*)/g;

        function searchFor(query, limits) {
            if (searchResults) {
                searchResults.destroy();
            }

            (0, _internalSearch.createSearch)((0, _$['default'])('#search-results'), query, limits).then(function (results) {
                return searchResults = results;
            });
        }

        function pushNewPageState(query) {
            var url = _Urls['default'].search(query);
            _history2['default'].pushState({
                query: query
            }, null, url);
        }

        function clearProjectAndRepo(query) {
            query = query.replace(CONTEXT_RE, '');
            return query.trim();
        }

        var CodeSearch = (function () {
            function CodeSearch(el, options) {
                var _this = this;

                _classCallCheck(this, CodeSearch);

                var $el = (0, _$['default'])(el);

                this.options = _2['default'].assign({}, CodeSearch.defaultOptions, options);

                $el.html(bitbucket.internal.component.codesearch.emptyState({
                    query: this.options.query
                }));

                _history2['default'].initialState({
                    query: this.options.query
                });
                _history2['default'].on('popstate', function (e) {
                    return _this._onPopState(e);
                });

                this.$searchForm = (0, _$['default'])('#search-form');
                this.$searchForm.submit(function (evt) {
                    return _this._onSearchSubmit(evt);
                });
                if (this.options.query && this.options.query !== '') {
                    searchFor(this.options.query, this.options.limits);
                }

                var $searchResults = (0, _$['default'])('#search-results');
                $searchResults.on('click', '.code-search-everwhere-link', function () {
                    var query = _this.$searchForm.find('input[name=search-input]').val();
                    query = clearProjectAndRepo(query);
                    _this._updateQuery(query);
                    pushNewPageState(query);
                    _Analytics['default'].searchEverywhereClicked();
                });
            }

            _createClass(CodeSearch, [{
                key: '_onSearchSubmit',
                value: function _onSearchSubmit(evt) {
                    var $query = (0, _$['default'])(evt.target).find('input.search-query');
                    var query = $query.val();

                    if (!query) {
                        return false;
                    }

                    searchFor(query, this.options.limits);
                    pushNewPageState(query);

                    return false;
                }
            }, {
                key: '_onPopState',
                value: function _onPopState(evt) {
                    var state = evt.state;
                    var query = state && state.query || '';
                    this._updateQuery(query);
                }
            }, {
                key: '_updateQuery',
                value: function _updateQuery(query) {
                    this.$searchForm.find('input[name=search-input]').val(query);
                    searchFor(query, this.options.limits);
                }
            }]);

            return CodeSearch;
        })();

        module.exports = CodeSearch;

        CodeSearch.defaultOptions = {
            limits: {
                primary: 10,
                secondary: 3
            }
        };
    }
);