define(
    'bitbucket/internal/bbui/utils/promise-middleware',
    ['exports', 'module', 'lodash'],
    function (exports, module, _lodash) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        module.exports = promiseMiddleware;

        /**
         * Redux middleware for handling asynchronous actions
         */

        function promiseMiddleware(_ref) {
            var dispatch = _ref.dispatch;

            return function (next) {
                return function (action) {
                    var meta = action.meta;

                    if (!meta || !meta.promise) {
                        return next(action);
                    }

                    // Generate a unique ID for the action to easily tie
                    // subsequent success and error actions to their original
                    // action
                    var actionId = Number((0, _lodash.uniqueId)());

                    // Attach status and ID to action object
                    function makeAction(payload, isPending) {
                        var newAction = _extends({}, action, {
                            payload: payload,
                            meta: _extends({}, meta, {
                                actionId: actionId,
                                isPending: isPending
                            })
                        });
                        delete newAction.meta.promise;
                        return newAction;
                    }

                    // Dispatch actions immediately, on success, and on error
                    dispatch(makeAction(action.payload, true));
                    return meta.promise.then(function (result) {
                        return dispatch(makeAction(result, false));
                    }, function (error) {
                        return dispatch(makeAction({ error: error }, false));
                    });
                };
            };
        }
    }
);