define(
    'bitbucket/internal/bbui/utils/create-reducer',
    ["exports", "module"],
    function (exports, module) {
        /**
         * Helper function for creating Redux reducers which allows us
         * to avoid using big switch-case statements and instead add
         * action listeners using object keys
         */
        "use strict";

        module.exports = createReducer;

        function createReducer(initialState, handlers) {
            return function (state, action) {
                if (state === undefined) state = initialState;

                if (handlers[action.type]) {
                    return handlers[action.type](state, action);
                }
                return state;
            };
        }
    }
);