define(
    'bitbucket/internal/bbui/pull-request-header',
    ['exports', 'module', 'react', 'aui', 'classnames', 'lodash', 'react-dom', './aui-react/avatar', './branch-from-to', './models', './participant-avatar-list', './reviewer-status', './pull-request-header/components/merge-button', './pull-request-header/components/merge-warning-dialog', './pull-request-header/components/pull-request-more'],
    function (exports, module, _react, _aui, _classnames, _lodash, _reactDom, _auiReactAvatar, _branchFromTo, _models, _participantAvatarList, _reviewerStatus, _componentsMergeButton, _componentsMergeWarningDialog, _componentsPullRequestMore) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _AJS = _interopRequireDefault(_aui);

        var _classNames = _interopRequireDefault(_classnames);

        var _2 = _interopRequireDefault(_lodash);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var _BranchFromTo = _interopRequireDefault(_branchFromTo);

        var _ParticipantAvatarList = _interopRequireDefault(_participantAvatarList);

        var _ReviewerStatus = _interopRequireDefault(_reviewerStatus);

        var _MergeButton = _interopRequireDefault(_componentsMergeButton);

        var _MergeWarningDialog = _interopRequireDefault(_componentsMergeWarningDialog);

        var _PullRequestMore = _interopRequireDefault(_componentsPullRequestMore);

        var propTypes = {
            currentUserAsReviewer: _react.PropTypes.object,
            currentUserStatus: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState)),
            onApproveClick: _react.PropTypes.func.isRequired,
            onMergeClick: _react.PropTypes.func.isRequired,
            onMergeWarningClick: _react.PropTypes.func.isRequired,
            onStatusClick: _react.PropTypes.func.isRequired,
            pullRequest: _react.PropTypes.object.isRequired
        };

        var PullRequestHeader = (function (_Component) {
            _inherits(PullRequestHeader, _Component);

            function PullRequestHeader() {
                _classCallCheck(this, PullRequestHeader);

                _get(Object.getPrototypeOf(PullRequestHeader.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(PullRequestHeader, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    _AJS['default'].$(node).tooltip();
                }
            }, {
                key: 'componentDidUpdate',
                value: function componentDidUpdate(prevProps) {
                    var pullRequest = this.props.pullRequest;

                    var showDialog = _2['default'].get(pullRequest, 'canMerge.showDialog', false);
                    var wasShowDialog = _2['default'].get(prevProps, 'pullRequest.canMerge.showDialog', false);
                    if (showDialog && !wasShowDialog) {
                        this._mergeWarningDialog.show();
                    } else if (!showDialog && wasShowDialog) {
                        this._mergeWarningDialog.hide();
                    }
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var pullRequest = this.props.pullRequest;

                    var merge = undefined;
                    var mergeDialog = undefined;

                    if (pullRequest.canMerge) {
                        merge = _React['default'].createElement(_MergeButton['default'], { onMergeClick: this.props.onMergeClick,
                            onMergeWarningClick: this.props.onMergeWarningClick,
                            mergeable: pullRequest.canMerge,
                            conflicted: pullRequest.canMerge.conflicted,
                            vetoes: pullRequest.canMerge.vetoes });

                        mergeDialog = _React['default'].createElement(_MergeWarningDialog['default'], { ref: function (c) {
                                return _this._mergeWarningDialog = c;
                            },
                            vetoes: pullRequest.canMerge.vetoes,
                            onDialogHide: this.props.onMergeWarningHide });
                    }

                    return _React['default'].createElement(
                        'div',
                        { className: 'pull-request-header' },
                        _React['default'].createElement(
                            'div',
                            { className: 'flexible' },
                            _React['default'].createElement(
                                'div',
                                { className: 'pull-request-metadata' },
                                _React['default'].createElement(_Avatar['default'], { className: 'author', person: pullRequest.author, withName: true, withLink: true }),
                                _React['default'].createElement(_BranchFromTo['default'], { fromRef: pullRequest.from_ref, toRef: pullRequest.to_ref }),
                                _React['default'].createElement(
                                    'div',
                                    { className: 'status aui-lozenge aui-lozenge-complete' },
                                    pullRequest.state
                                )
                            ),
                            _React['default'].createElement(
                                'div',
                                { className: (0, _classNames['default'])('pull-request-actions', { reviewing: this.props.currentUserAsReviewer }) },
                                _React['default'].createElement(_ParticipantAvatarList['default'], {
                                    participants: pullRequest.reviewers,
                                    menuId: 'overflow-reviewers',
                                    triggerClass: 'overflow-reviewers-trigger',
                                    maxOpen: '4',
                                    avatarSize: 'small',
                                    reverse: true }),
                                _React['default'].createElement(_ReviewerStatus['default'], { onStatusClick: this.props.onStatusClick, status: this.props.currentUserStatus }),
                                merge,
                                _React['default'].createElement(_PullRequestMore['default'], { onMoreAction: this.props.onMoreAction }),
                                mergeDialog
                            )
                        ),
                        _React['default'].createElement(
                            'h2',
                            null,
                            pullRequest.title
                        )
                    );
                }
            }]);

            return PullRequestHeader;
        })(_react.Component);

        PullRequestHeader.propTypes = propTypes;

        module.exports = PullRequestHeader;
    }
);