define(
    'bitbucket/internal/bbui/image-differ',
    ['exports', 'module', './image-differ/image-differ', './image-differ/image-differ-toolbar', 'jquery'],
    function (exports, module, _imageDiffer, _imageDifferToolbar, _jquery) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _Differ = _interopRequireDefault(_imageDiffer);

        var _Toolbar = _interopRequireDefault(_imageDifferToolbar);

        var _$ = _interopRequireDefault(_jquery);

        /**
         * @param {jQuery|HtmlElement} container
         * @returns {{on: Function, readyPromise: Promise}}
         */
        function init(container) {
            var $container = (0, _$['default'])(container);
            var toolbar = new _Toolbar['default']((0, _$['default'])(bitbucket.internal.component.imageDiffer.toolbar.main()).prependTo($container));
            var differ = new _Differ['default']($container);

            toolbar.on('modeChanged', function (mode) {
                differ.setMode(mode.newMode);
            });

            var readyPromise = new _$['default'].Deferred();
            differ.init().done(function (enabledModes) {
                if (toolbar) {
                    toolbar.init(enabledModes);
                }
                readyPromise.resolve({
                    /**
                     * Stop exposing this method when Stash no longer needs to retrigger Image Differ events
                     * @deprecated
                     */
                    on: differ.on.bind(differ),
                    enabledModes: enabledModes,
                    _differ: differ,
                    _toolbar: toolbar,
                    destroy: function destroy() {
                        differ.destroy();
                        differ = null;
                        toolbar.destroy();
                        toolbar = null;
                    }
                });
            });
            return readyPromise;
        }

        module.exports = {
            init: init,
            Differ: _Differ['default'],
            Toolbar: _Toolbar['default']
        };
    }
);