define(
    'bitbucket/internal/bbui/avatar-list',
    ['exports', 'module', 'lodash', 'jquery', './models'],
    function (exports, module, _lodash, _jquery, _models) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _2 = _interopRequireDefault(_lodash);

        var _$ = _interopRequireDefault(_jquery);

        var _models2 = _interopRequireDefault(_models);

        module.exports = {
            updateApproval: function updateApproval(listEl, participant) {
                var $avatars = (0, _$['default'])(listEl).find(".user-avatar[data-username='" + participant.getUser().getName() + "']");
                $avatars.toggleClass('badge-hidden', !participant.getApproved());
            },

            sortParticipants: function sortParticipants(participants) {
                function compare(a, b) {
                    if (a.state === b.state) {
                        return a.user.display_name.localeCompare(b.user.display_name);
                    } else {
                        return a.state === _models2['default'].ApprovalState.APPROVED ? -1 : 1;
                    }
                    return 0;
                }
                return participants.sort(compare);
            },

            init: _2['default'].once(function () {
                (0, _$['default'])('.avatar-tooltip > .aui-avatar-inner > img').tooltip({
                    hoverable: false,
                    offset: 5,
                    gravity: function gravity() {
                        // Always position on screen
                        return _$['default'].fn.tipsy.autoNS.call(this) + _$['default'].fn.tipsy.autoWE.call(this);
                    },
                    delayIn: 0,
                    live: true
                });
            })

        };
    }
);