define('bitbucket/internal/feature/pull-request/merge-help', [
    'aui',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/util/events'
], function (
    AJS,
    nav,
    events
) {

    var dialog;

    function mergeHelpDialog(pullRequest, conflicted, vetoes, properties) {

        // If dialog does not exist create it
        if (!dialog) {
            dialog = AJS.dialog2(bitbucket.internal.feature.pullRequest.mergeHelpDialog());
            dialog.$el.find('.dialog-close-button').click(function() {
                dialog.hide();
            });

            // we manually add the dialog to the body so that it's on the DOM and available for the automerge-decorator
            // to replace the contents if necessary
            dialog.$el.appendTo('body');
        }

        // If the dialog already exists just update the inner content.
        var sourceRepo = pullRequest.getFromRef().getRepository();
        var targetRepo = pullRequest.getToRef().getRepository();
        var sourceRemote = null;
        var targetRemote = null;

        if (!sourceRepo.isEqual(targetRepo)) {
            sourceRemote = nav.project(sourceRepo.getProject()).repo(sourceRepo).clone(sourceRepo.getScmId()).buildAbsolute();
            targetRemote = nav.project(targetRepo.getProject()).repo(targetRepo).clone(targetRepo.getScmId()).buildAbsolute();
        }

        dialog.$el.find('.aui-dialog2-content').html(
            bitbucket.internal.feature.pullRequest.mergeHelp({
                sourceBranch: pullRequest.getFromRef().getDisplayId(),
                targetBranch: pullRequest.getToRef().getDisplayId(),
                sourceRemote: sourceRemote,
                targetRemote: targetRemote,
                conflicted: conflicted,
                vetoes: vetoes
            })
        );
    }

    function showMergeHelpDialog() {
        if (dialog) {
            dialog.show();
        }
    }

    var cantMergeHandler = function(pullRequest, conflicted, vetoes, properties) {
        mergeHelpDialog(pullRequest, conflicted, vetoes, properties);
    };

    return {
        init : function() {
            events.on('bitbucket.internal.pull-request.cant.merge', cantMergeHandler);
            events.on('bitbucket.internal.pull-request.show.cant.merge.help', showMergeHelpDialog);

        },
        reset : function() {
            events.off('bitbucket.internal.pull-request.cant.merge', cantMergeHandler);
            events.off('bitbucket.internal.pull-request.show.cant.merge.help', showMergeHelpDialog);
            if (dialog) {
                dialog.remove();
                dialog = null;
            }
        }
    };
});
