define(
    'bitbucket/internal/bbui/reducers/pull-request-reviewers',
    ['exports', 'module', 'lodash', '../models', '../pull-request-header/actions', '../utils/create-reducer', '../utils/merge-object-in-array', '../utils/replace-state-with-rollback'],
    function (exports, module, _lodash, _models, _pullRequestHeaderActions, _utilsCreateReducer, _utilsMergeObjectInArray, _utilsReplaceStateWithRollback) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        var _2 = _interopRequireDefault(_lodash);

        var _createReducer2 = _interopRequireDefault(_utilsCreateReducer);

        var _mergeObjectInArray = _interopRequireDefault(_utilsMergeObjectInArray);

        var _replaceWithRollback = _interopRequireDefault(_utilsReplaceStateWithRollback);

        module.exports = (0, _createReducer2['default'])([], _defineProperty({}, _pullRequestHeaderActions.PR_CHANGE_REVIEWER_STATE, function (state, action) {
            var reviewerFinder = function reviewerFinder(reviewer) {
                return reviewer.user.name === action.payload.user.name;
            };
            var index = _2['default'].findIndex(state, reviewerFinder);
            var currentReviewState = state[index].state;

            return (0, _replaceWithRollback['default'])(state, action, {
                forward: function forward() {
                    return (0, _mergeObjectInArray['default'])(state, reviewerFinder, { state: action.payload.newState });
                },
                back: function back() {
                    return (0, _mergeObjectInArray['default'])(state, reviewerFinder, { state: currentReviewState });
                }
            });
        }));
    }
);