define(
    'bitbucket/internal/bbui/pull-request-header/components/merge-button',
    ['exports', 'module', 'react', 'jquery', 'react-dom', './spinner'],
    function (exports, module, _react, _jquery, _reactDom, _spinner) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _$ = _interopRequireDefault(_jquery);

        var _Spinner = _interopRequireDefault(_spinner);

        var defaultProps = {
            mergeable: {
                isChecking: false,
                canMerge: true
            }
        };

        var propTypes = {
            onMergeClick: _react.PropTypes.func.isRequired,
            onMergeWarningClick: _react.PropTypes.func.isRequired
        };

        var MergeButton = (function (_Component) {
            _inherits(MergeButton, _Component);

            function MergeButton() {
                _classCallCheck(this, MergeButton);

                _get(Object.getPrototypeOf(MergeButton.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(MergeButton, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    (0, _$['default'])(node).tooltip({
                        live: true
                    });
                }
            }, {
                key: 'onClick',
                value: function onClick() {
                    if (this.props.mergeable.canMerge) {
                        this.props.onMergeClick();
                    } else {
                        this.props.onMergeWarningClick();
                    }
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var mergeable = this.props.mergeable;
                    var _props = this.props;
                    var conflicted = _props.conflicted;
                    var _props$vetoes = _props.vetoes;
                    var vetoes = _props$vetoes === undefined ? [] : _props$vetoes;
                    var onMergeWarningClick = _props.onMergeWarningClick;

                    var title = '';
                    if (!mergeable.canMerge) {
                        if (conflicted && (!vetoes || vetoes.length === 0)) {
                            title = AJS.I18n.getText('bitbucket.web.pullrequest.merge.conflict.tooltip');
                        } else if (vetoes && vetoes.length === 1 && !conflicted) {
                            title = vetoes[0].detailedMessage;
                        } else {
                            title = AJS.I18n.getText('bitbucket.web.pullrequest.merge.issue.tooltip');
                        }
                    }

                    var enabled = !mergeable.isChecking && mergeable.canMerge;

                    var content = undefined;
                    if (enabled) {
                        content = AJS.I18n.getText('bitbucket.web.pullrequest.toolbar.merge');
                    } else if (mergeable.isChecking) {
                        content = _React['default'].createElement(_Spinner['default'], null);
                    } else {
                        content = _React['default'].createElement('span', { className: 'merge-disabled' });
                    }

                    return _React['default'].createElement(
                        'button',
                        { onClick: function () {
                                return _this.onClick();
                            }, className: 'aui-button', 'aria-disabled': !enabled, title: title },
                        content
                    );
                }
            }]);

            return MergeButton;
        })(_react.Component);

        MergeButton.defaultProps = defaultProps;
        MergeButton.propTypes = propTypes;

        module.exports = MergeButton;
    }
);