define(
    'bitbucket/internal/bbui/history/History',
    ['exports', 'module', '../widget', 'internal/util/navigator'],
    function (exports, module, _widget, _internalUtilNavigator) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _Widget2 = _interopRequireDefault(_widget);

        var _navigatorUtil = _interopRequireDefault(_internalUtilNavigator);

        // redefined so we can mock it in tests
        var localWindow = window;

        var History = (function (_Widget) {
            _inherits(History, _Widget);

            function History() {
                _classCallCheck(this, History);

                _get(Object.getPrototypeOf(History.prototype), 'constructor', this).call(this);
                this.titleSuffix = '';
                this._init();
            }

            _createClass(History, [{
                key: 'pushState',
                value: function pushState(state, title, url) {
                    localWindow.history.pushState(state, title || '', url || '');
                    this._maybeSetTitle(title);
                    this.trigger('changestate', { state: state });
                }
            }, {
                key: 'replaceState',
                value: function replaceState(state, title, url) {
                    localWindow.history.replaceState(state, title || '', url || '');
                    this._maybeSetTitle(title);
                    this.trigger('changestate', { state: state });
                }
            }, {
                key: 'state',
                value: function state() {
                    return localWindow.history.state;
                }
            }, {
                key: 'initialState',
                value: function initialState(state) {
                    return localWindow.history.replaceState(state, '', localWindow.location.href);
                }
            }, {
                key: 'setTitleSuffix',
                value: function setTitleSuffix(suffix) {
                    this.titleSuffix = suffix || '';
                }
            }, {
                key: '_init',
                value: function _init() {
                    var _this = this;

                    //Safari fires an event on every page load. We want to swallow this event.
                    var skipNextPop = _navigatorUtil['default'].isSafari();
                    var listener = function listener(e) {
                        //The initial event in Safari has event.state === null so if the first event has some state
                        //then let it through.
                        if (e && (!skipNextPop || e.state !== null)) {
                            _this.trigger('popstate', e);
                            _this.trigger('changestate', e);
                        }

                        if (skipNextPop) {
                            skipNextPop = false;
                        }
                    };
                    localWindow.addEventListener('popstate', listener);

                    this._addDestroyable(function () {
                        localWindow.removeEventListener('popstate', listener);
                    });
                }
            }, {
                key: '_maybeSetTitle',
                value: function _maybeSetTitle(title) {
                    if (title) {
                        localWindow.document.title = title + this.titleSuffix;
                    }
                }
            }]);

            return History;
        })(_Widget2['default']);

        module.exports = History;
    }
);