# bitbucket-json-validation

> Validation of JSON shapes.

## Installation

```
> bower install --save bitbucket-json-validation
```

## Usage

This module lets you validate that a JS object has certain properties that meet certain characteristics (namely that they are of a certain type).

For example:

```js
import validator from 'bitbucket/internal/json-validation';

// validate that something is a string
var stringValidator = validator('string');

stringValidator('passes'); // passes
stringValidator(null);     // THROWS

// validate that something is a nullable number
var nullableNumberValidator = validator('number?');

nullableNumberValidator(null); // passes
nullableNumberValidator(0);    // passes
nullableNumberValidator('0');  // THROWS

//validate an array of numbers
var numbersValidator = validator(['number']);

numbersValidator([0]);      // passes
numbersValidator([]);       // passes
numbersValidator([0, 's']); // THROWS
numbersValidator('s');      // THROWS

// validate complex things, like an array of "fruits"
var validateFruits = validator([{
    freshness: 'number',
    variety: 'string?',
    type: validator.asEnum('FruitType', {
        APPLE: 'APPLE',
        ORANGE: 'ORANGE'
    }),
    source: function(source) { // a function lets you provide custom validation, like string OR farm
        if (typeof source === 'string') return;
        var farmShape = {...};
        validator(farmShape)(source); // throws if source doesn't match a farm shape
    }
}]);

```

## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt test
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release-prepare`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 1.0.0

Initial release
