define(
    'bitbucket/internal/bbui/quick-search',
    ['exports', 'module', 'jquery', 'aui', 'bitbucket/internal/impl/urls', './bb-panel'],
    function (exports, module, _jquery, _aui, _bitbucketInternalImplUrls, _bbPanel) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        var _$ = _interopRequireDefault(_jquery);

        var _AJS = _interopRequireDefault(_aui);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var MIN_TERMS_DISPLAY = 3;

        var QuickSearch = (function () {
            function QuickSearch(el, options) {
                var _this = this;

                _classCallCheck(this, QuickSearch);

                this.options = options;
                this.useContext = !!(options.project || options.repository);

                var $searchBox = (0, _$['default'])(bitbucket.internal.component.quickSearch.searchBox());
                this.$input = $searchBox.find('#quick-search');
                (0, _$['default'])(el).replaceWith($searchBox);

                var $panel = (0, _$['default'])(bitbucket.internal.component.quickSearch.searchPanel());
                $panel.appendTo((0, _$['default'])('body'));
                this.panel = $panel[0];

                this.$codeSearchHint = $panel.find('.code-search-hint');
                this.$terms = this.$codeSearchHint.find('.terms');

                this.$input.on('blur', function (e) {
                    return _this._onBlur(e);
                });
                this.$input.on('focus', function (e) {
                    return _this._onFocus(e);
                });
                this.$input.on('keyup', function (e) {
                    return _this._onKeyUp(e);
                });
                this.$input.on('keydown', function (e) {
                    return _this._onKeyDown(e);
                });
                (0, _$['default'])($searchBox[0]).on('submit', function (e) {
                    return e.preventDefault();
                });
            }

            /*
             * This component does its own focus management via blur,focus,keydown rather than using `data-aui-trigger`.
             * We do this because there are cases where we don't want the dialog to open when the field is focused.
             * For example in a global context there is nothing to show the dialog should be hidden.
             *
             * When the search suggested operators are added we should be able to go back to `data-aui-trigger` on the input
             * because we will always have something to show in the dialog.
             */

            _createClass(QuickSearch, [{
                key: 'doCodeSearch',
                value: function doCodeSearch(terms) {
                    var search = [];
                    if (this.useContext) {
                        if (this.options.project) {
                            search.push('project:' + this.options.project.key);
                        }
                        if (this.options.repository) {
                            search.push('repo:' + this.options.repository.slug);
                        }
                    }
                    search.push(terms);
                    window.location = _urls['default'].search(search.join(' '));
                }
            }, {
                key: 'focus',
                value: function focus() {
                    this.$input.focus();
                }
            }, {
                key: '_onBlur',
                value: function _onBlur(e) {
                    this._updatePanel(false);
                }
            }, {
                key: '_onFocus',
                value: function _onFocus(e) {
                    var currentTerms = this.$input.val();
                    this._updatePanel(currentTerms.length >= MIN_TERMS_DISPLAY);
                }
            }, {
                key: '_onKeyDown',
                value: function _onKeyDown(e) {}
            }, {
                key: '_onKeyUp',
                value: function _onKeyUp(e) {
                    var newTerms = this.$input.val();
                    this._updatePanel(e.keyCode !== _AJS['default'].keyCode.ESCAPE && newTerms.length >= MIN_TERMS_DISPLAY);

                    if (e.keyCode === _AJS['default'].keyCode.ENTER) {
                        if (newTerms.length > 1) {
                            this.doCodeSearch(newTerms);
                        } else {
                            e.preventDefault();
                        }
                    } else if (e.keyCode === _AJS['default'].keyCode.DOWN || e.keyCode === _AJS['default'].keyCode.UP) {
                        // TODO do some up/down nav
                    } else {
                            this._updateSearchTerms(newTerms);
                        }
                }
            }, {
                key: '_updateSearchTerms',
                value: function _updateSearchTerms(terms) {
                    this.$codeSearchHint.toggleClass('hidden', terms.length < MIN_TERMS_DISPLAY);
                    this.$terms.text(terms);
                }
            }, {
                key: '_updatePanel',
                value: function _updatePanel(open) {
                    this.panel.open = open;
                }
            }]);

            return QuickSearch;
        })();

        module.exports = QuickSearch;
    }
);