define(
    'bitbucket/internal/bbui/pull-request-list',
    ['exports', 'module', './widget', './filter-bar', 'bitbucket/internal/impl/data-provider/participants', './pull-request-table', 'bitbucket/internal/impl/data-provider/pull-request-list', 'bitbucket/internal/impl/data-provider/ref', './models', 'aui', 'jquery', 'lodash', './pull-request-list/dom-event', 'bitbucket/internal/impl/urls'],
    function (exports, module, _widget, _filterBar, _bitbucketInternalImplDataProviderParticipants, _pullRequestTable, _bitbucketInternalImplDataProviderPullRequestList, _bitbucketInternalImplDataProviderRef, _models, _aui, _jquery, _lodash, _domEvent, _bitbucketInternalImplUrls) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _Widget2 = _interopRequireDefault(_widget);

        var _FilterBar = _interopRequireDefault(_filterBar);

        var _ParticipantsDataProvider2 = _interopRequireDefault(_bitbucketInternalImplDataProviderParticipants);

        var _PullRequestTable = _interopRequireDefault(_pullRequestTable);

        var _PullRequestListDataProvider = _interopRequireDefault(_bitbucketInternalImplDataProviderPullRequestList);

        var _RefDataProvider = _interopRequireDefault(_bitbucketInternalImplDataProviderRef);

        var _models2 = _interopRequireDefault(_models);

        var _AJS = _interopRequireDefault(_aui);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _openInSameTab = _interopRequireDefault(_domEvent);

        // for soy

        var PullRequestList = (function (_Widget) {
            _inherits(PullRequestList, _Widget);

            /**
             * @param {jQuery|HTMLElement} el
             * @param {Object} options
             * @param {Repository?} options.repository
             * @param {User?} options.currentUser
             * @param {Array<PullRequest>?} options.initialData - if you'd like to pass in a prefetched page of PRs, this is it.
             * @param {Object?} options.filter
             * @param {boolean} options.filter.reviewer_self - true to filter to just ones where the current user is a reviewer.
             * @param {Object?} options.authorFilter - The filter to pass to the author participants data provider
             * @param {models.PullRequestState?} options.filter.state
             * @param {Ref?} options.selectedTargetBranch
             * @param {Participant?} options.selectedAuthor
             */

            function PullRequestList(el, options) {
                var _this = this;

                _classCallCheck(this, PullRequestList);

                _get(Object.getPrototypeOf(PullRequestList.prototype), 'constructor', this).call(this, options);

                options.filter = options.filter || {};
                options.filter.author_id = options.selectedAuthor && options.selectedAuthor.name;
                options.filter.target_ref_id = options.selectedTargetBranch && options.selectedTargetBranch.id;

                // we probably should make this reusable, but since this is the only place that needs it, I've punted on doing that for now.
                // The next person who want sto do preloading should extract this into something shareable (e.g., perhaps some kind of mixin
                // instead of inheriting from the user-specific provider)

                var PreloadingParticipantsDataProvider = (function (_ParticipantsDataProvider) {
                    _inherits(PreloadingParticipantsDataProvider, _ParticipantsDataProvider);

                    function PreloadingParticipantsDataProvider(options) {
                        var _get2;

                        _classCallCheck(this, PreloadingParticipantsDataProvider);

                        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                            args[_key - 1] = arguments[_key];
                        }

                        (_get2 = _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), 'constructor', this)).call.apply(_get2, [this, options].concat(args));

                        this._preloadItems = options.preload || [];
                        this._preloaded = this._initialPreloadedState = this._preloadItems.length === 0;
                        this._equalityCheck = options.equals || function (a, b) {
                            return a.id === b.id;
                        };
                    }

                    _createClass(PreloadingParticipantsDataProvider, [{
                        key: 'reset',
                        value: function reset() {
                            this._preloaded = this._initialPreloadedState;
                            return _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), 'reset', this).call(this);
                        }
                    }, {
                        key: '_fetchNext',
                        value: function _fetchNext(lastResponseData) {
                            if (!this._preloaded) {
                                if (this.filter.term) {
                                    this._preloaded = true;
                                } else {
                                    var promise = _$['default'].Deferred().resolve(this._preloadItems);
                                    promise.abort = _$['default'].noop;
                                    return promise;
                                }
                            }

                            return _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), '_fetchNext', this).call(this, lastResponseData === this._preloadItems ? null : lastResponseData);
                        }
                    }, {
                        key: '_transform',
                        value: function _transform(data) {
                            if (!this._preloaded) {
                                this._preloaded = true;
                                return this._preloadItems;
                            }

                            var equals = this._equalityCheck;
                            var preloadItems = this._preloadItems;
                            var out = _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), '_transform', this).call(this, data);
                            if (this.filter.term) {
                                return out;
                            } else {
                                // if we're not filtering, exclude the preloaded items from the output
                                return out.filter(function (item) {
                                    return !preloadItems.some(function (preloadItem) {
                                        return equals(preloadItem, item);
                                    });
                                });
                            }
                        }
                    }]);

                    return PreloadingParticipantsDataProvider;
                })(_ParticipantsDataProvider2['default']);

                var authorProvider = new PreloadingParticipantsDataProvider({
                    preload: options.currentUser ? [options.currentUser] : null,
                    equals: function equals(a, b) {
                        return a.name === b.name;
                    },
                    repository: options.repository,
                    filter: options.authorFilter || {}
                });

                var branchProvider = new _RefDataProvider['default']({
                    filter: {
                        repository: options.repository,
                        type: 'branch'
                    }
                });

                var prProvider = new _PullRequestListDataProvider['default']({
                    repository: options.repository.id,
                    filter: {
                        state: options.filter.state || _models2['default'].PullRequestState.OPEN,
                        author_id: options.filter.author_id || null,
                        target_ref_id: options.filter.target_ref_id || null,
                        reviewer_id: options.filter.reviewer_self && options.currentUser ? options.currentUser.name : null
                    }
                }, options.initialData);

                var pullRequestListFilters = [{
                    id: 'pr-state-filter',
                    type: _FilterBar['default'].Types.SELECT,
                    text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.state'),
                    value: options.filter.state,
                    menu: {
                        items: [{ id: _models2['default'].PullRequestState.OPEN, text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.state.open') }, { id: _models2['default'].PullRequestState.MERGED, text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.state.merged') }, { id: _models2['default'].PullRequestState.DECLINED, text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.state.declined') }]
                    }
                }, {
                    type: _FilterBar['default'].Types.SELECT,
                    text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.author'),
                    id: 'pr-author-filter',
                    value: options.filter.author_id || null,
                    searchPlaceholder: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.search.author'),
                    menu: {
                        dataProvider: authorProvider,
                        id: function id(user) {
                            return user.name;
                        },
                        initSelection: function initSelection($el, callback) {
                            var username = $el.val();
                            if (options.filter.author_id === username) {
                                return callback(options.selectedAuthor);
                            }
                            throw new Error('Unexpected value \'' + username + '\' when initializing the author filter.');
                        },
                        formatSelection: function formatSelection(author, container) {
                            return bitbucket.internal.component.pullRequestList.authorSelection({ author: author });
                        },
                        formatResult: function formatResult(author, container) {
                            return bitbucket.internal.component.pullRequestList.authorResult({ author: author });
                        },
                        formatNoMatches: function formatNoMatches() {
                            return _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.search.author.nomatches');
                        },
                        placeholder: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.author'),
                        dropdownCssClass: 'pr-author-dropdown'
                    }
                }, {
                    type: _FilterBar['default'].Types.SELECT,
                    text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.branch.target'),
                    id: 'pr-target-branch-filter',
                    value: options.filter.target_ref_id || null,
                    searchPlaceholder: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.search.branch'),
                    menu: {
                        dataProvider: branchProvider,
                        initSelection: function initSelection($el, callback) {
                            var branch = $el.val();
                            if (options.filter.target_ref_id === branch) {
                                return callback(options.selectedTargetBranch);
                            }
                            throw new Error('Unexpected value \'' + branch + '\' when initializing the target branch filter.');
                        },
                        formatSelection: function formatSelection(branch, container) {
                            return bitbucket.internal.component.pullRequestList.targetBranchSelection({ branch: branch });
                        },
                        formatResult: function formatResult(branch, container) {
                            return bitbucket.internal.component.pullRequestList.targetBranchResult({ branch: branch });
                        },
                        formatNoMatches: function formatNoMatches() {
                            return _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.search.branch.nomatches');
                        },
                        placeholder: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.branch.target'),
                        dropdownCssClass: 'pr-target-branch-dropdown'
                    }
                }];

                if (options.currentUser) {
                    // anonymous users shouldn't see the "I'm reviewing"
                    pullRequestListFilters.push({
                        type: _FilterBar['default'].Types.TOGGLE,
                        text: _AJS['default'].I18n.getText('bitbucket.component.pull.request.list.reviewer.self'),
                        id: 'pr-reviewer-self-filter',
                        value: options.filter.reviewer_self
                    });
                }

                var filterBar = new _FilterBar['default'](el, {
                    id: 'pull-requests-filter-bar',
                    filters: pullRequestListFilters
                });

                this.pullRequestTable = new _PullRequestTable['default'](el, {
                    id: 'pull-requests-table',
                    dataProvider: prProvider,
                    isFiltered: function isFiltered() {
                        var filter = prProvider.filter;
                        return filter.state !== 'OPEN' || filter.author_id || filter.target_ref_id || filter.reviewer_id;
                    },
                    repository: options.repository,
                    noneMatchingMessageHtml: bitbucket.internal.component.pullRequestList.noneMatchingMsg({ repository: options.repository })
                });

                this.pullRequestTable.init();

                var resetFilters = function resetFilters() {
                    filterBar.state = _2['default'].transform(pullRequestListFilters, function (state, filter) {
                        state[filter.id] = filter.menu && filter.menu.items ? filter.menu.items[0].id : false;
                    }, {});
                };

                (0, _$['default'])(el).on('click', '#reset-filters', function (e) {
                    if ((0, _openInSameTab['default'])(e)) {
                        e.preventDefault();
                        resetFilters();
                    }
                });

                filterBar.on('change', function () {
                    var filterState = filterBar.state;
                    var cleanState = {
                        state: filterState['pr-state-filter'],
                        author_id: filterState['pr-author-filter'] || null,
                        target_ref_id: filterState['pr-target-branch-filter'] || null,
                        reviewer_self: filterState['pr-reviewer-self-filter']
                    };

                    prProvider.setFilter('state', cleanState.state);
                    prProvider.setFilter('author_id', cleanState.author_id);
                    prProvider.setFilter('target_ref_id', cleanState.target_ref_id);
                    prProvider.setFilter('reviewer_id', cleanState.reviewer_self && options.currentUser ? options.currentUser.name : null);
                    prProvider.reset();

                    _this.trigger('state-change', cleanState);
                });

                // if there isn't a focused row set focus to the inital row in the table.
                var focusInitialRowIfNeeded = function focusInitialRowIfNeeded() {
                    if (!_this.pullRequestTable._getFocusedItem().length) {
                        _this.pullRequestTable.focusInitialRow();
                    }
                };
                // when a page is rendered, check if we need to focus the initial row.
                this.pullRequestTable.on('page-rendered', focusInitialRowIfNeeded);
                focusInitialRowIfNeeded();
            }

            _createClass(PullRequestList, [{
                key: 'getKeyboardAction',
                value: function getKeyboardAction(action) {
                    var kbdAction = this._keyboardActions[action];
                    if (typeof kbdAction === 'function') {
                        return kbdAction;
                    }
                    throw new Error('No keyboard action has been defined for \'' + action + '\'.');
                }
            }, {
                key: '_keyboardActions',
                get: function get() {
                    return {
                        moveNext: this.pullRequestTable.moveNext,
                        movePrevious: this.pullRequestTable.movePrevious,
                        openItem: this.pullRequestTable.openItem
                    };
                }
            }]);

            return PullRequestList;
        })(_Widget2['default']);

        module.exports = PullRequestList;
    }
);