define(
    'bitbucket/internal/bbui/codesearch/internal/search-results-table',
    ['exports', 'module', 'lodash', 'jquery', '../../paged-table', './search-data-provider', '../../avatars'],
    function (exports, module, _lodash, _jquery, _pagedTable, _searchDataProvider, _avatars) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _2 = _interopRequireDefault(_lodash);

        var _$ = _interopRequireDefault(_jquery);

        var _PagedTable2 = _interopRequireDefault(_pagedTable);

        var _CodeSearchDataProvider = _interopRequireDefault(_searchDataProvider);

        var SearchResultsTable = (function (_PagedTable) {
            _inherits(SearchResultsTable, _PagedTable);

            function SearchResultsTable(el, options) {
                _classCallCheck(this, SearchResultsTable);

                _get(Object.getPrototypeOf(SearchResultsTable.prototype), 'constructor', this).call(this, _2['default'].extend({
                    tableEl: el,
                    autoLoad: 'next',
                    tableMessageClass: 'message',
                    rowSelector: '.code-search-result',
                    allFetchedMessageHtml: bitbucket.internal.component.codesearch.allResults(),
                    noneFoundMessageHtml: bitbucket.internal.component.codesearch.noResults({
                        query: options.dataProvider.options.query
                    })
                }, options));
            }

            _createClass(SearchResultsTable, [{
                key: 'handleNewRows',
                value: function handleNewRows(data, attachmentMethod) {
                    var rows = data.map(function (result) {
                        return bitbucket.internal.component.codesearch.codeResult({
                            result: result
                        });
                    });
                    this.$table.append(rows);
                    // One off scroll of the match into view
                    this.$table.find('.new-code-block').each(function (idx, elem) {
                        var $code = (0, _$['default'])(elem);
                        var $em = $code.find('em').first();
                        if ($em.length === 1) {
                            $code.scrollLeft($em.offset().left - Math.floor($code.width() / 2));
                        }
                    }).removeClass('new-code-block');
                    (0, _$['default'])('.code-search-filename', this.$table).tooltip({
                        gravity: 'nw'
                    });
                }
            }, {
                key: 'handleErrors',
                value: function handleErrors(errors) {
                    // TODO implement :)
                    console.error(errors);
                }
            }]);

            return SearchResultsTable;
        })(_PagedTable2['default']);

        module.exports = SearchResultsTable;
    }
);