define(
    'bitbucket/internal/bbui/codesearch',
    ['exports', 'module', 'jquery', './codesearch/internal/search', './codesearch/internal/search-entities', './codesearch/internal/push-state-manager', 'bitbucket/internal/impl/urls'],
    function (exports, module, _jquery, _internalSearch, _internalSearchEntities, _internalPushStateManager, _bitbucketInternalImplUrls) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        var _$ = _interopRequireDefault(_jquery);

        var _SearchEntities = _interopRequireDefault(_internalSearchEntities);

        var _PushStateManager = _interopRequireDefault(_internalPushStateManager);

        var _Urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var searchResults = undefined;
        var pushStateManager = null;

        var CONTEXT_RE = /(project:\S*)|(repo:\S*)/g;

        function searchFor(query) {
            if (searchResults) {
                searchResults.destroy();
            }

            (0, _internalSearch.createSearch)((0, _$['default'])('#search-results'), query).then(function (results) {
                return searchResults = results;
            });
        }

        function onSearchSubmit(evt) {
            var $query = (0, _$['default'])(evt.target).find('input.search-query');
            var query = $query.val();

            if (!query) {
                return false;
            }

            searchFor(query);
            pushNewPageState(query);

            return false;
        }

        function pushNewPageState(query) {
            var url = _Urls['default'].search(query);
            pushStateManager.pushState({
                query: query
            }, null, url);
        }

        function clearProjectAndRepo(query) {
            query = query.replace(CONTEXT_RE, '');
            return query.trim();
        }

        var CodeSearch = (function () {
            function CodeSearch(el, options) {
                var _this = this;

                _classCallCheck(this, CodeSearch);

                var $el = (0, _$['default'])(el);
                $el.html(bitbucket.internal.component.codesearch.emptyState({
                    query: options.query
                }));

                pushStateManager = new _PushStateManager['default']({
                    initialState: {
                        query: options.query
                    }
                });
                pushStateManager.on('popstate', function (e) {
                    return _this._onPopState(e);
                });

                this.$searchForm = (0, _$['default'])('#search-form');
                this.$searchForm.submit(onSearchSubmit);
                if (options.query && options.query !== '') {
                    searchFor(options.query);
                }

                var $searchResults = (0, _$['default'])('#search-results');
                $searchResults.on('click', '.code-search-everwhere-link', function () {
                    var query = _this.$searchForm.find('input[name=search-input]').val();
                    query = clearProjectAndRepo(query);
                    _this._updateQuery(query);
                    pushNewPageState(query);
                });
            }

            _createClass(CodeSearch, [{
                key: '_onPopState',
                value: function _onPopState(evt) {
                    var state = evt.state;
                    var query = state && state.query || '';
                    this._updateQuery(query);
                }
            }, {
                key: '_updateQuery',
                value: function _updateQuery(query) {
                    this.$searchForm.find('input[name=search-input]').val(query);
                    searchFor(query);
                }
            }]);

            return CodeSearch;
        })();

        module.exports = CodeSearch;
    }
);