import WebFragments from 'bitbucket/internal/spi/web-fragments';

class MockWebFragments extends WebFragments {
    getWebItems(location, context) {
        return [WebFragments.getExampleItem(location, context)];
    }

    getWebSections(location, context) {
        return [WebFragments.getExampleSection(location, context)];
    }

    getWebPanels(location, context) {
        return [WebFragments.getExamplePanel(location, context)];
    }

    getWebFragments(location, types, context) {
        return types.map(function(type) {
            switch(type) {
                case 'ITEM':    return WebFragments.getExampleItem(location, context);
                case 'SECTION': return WebFragments.getExampleSection(location, context);
                case 'PANEL':   return WebFragments.getExamplePanel(location, context);
            }
        });
    }
}

export default new MockWebFragments();