(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/spi/user-data-provider', 'bitbucket/internal/mock-models'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/user-data-provider', ['exports', 'module', 'bitbucket/internal/spi/user-data-provider', 'bitbucket/internal/mock-models'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var UserDataProvider = require("bitbucket/internal/spi/user-data-provider");
var mocks = require("bitbucket/internal/mock-models");

var MockUserDataProvider = (function (_UserDataProvider) {
    function MockUserDataProvider() {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        _classCallCheck(this, MockUserDataProvider);

        _get(Object.getPrototypeOf(MockUserDataProvider.prototype), "constructor", this).apply(this, args);
    }

    _inherits(MockUserDataProvider, _UserDataProvider);

    _createClass(MockUserDataProvider, {
        _transform: {
            value: function _transform(d) {
                var users = d.values.map(function (junk, i) {
                    return mocks.user(null, i);
                });
                return users;
            }
        }
    });

    return MockUserDataProvider;
})(UserDataProvider);

module.exports = MockUserDataProvider;

});
