(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/paged-data-provider', 'bitbucket/internal/models', 'bitbucket/internal/json-validation'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/spi/ref-data-provider', ['exports', 'module', 'bitbucket/internal/paged-data-provider', 'bitbucket/internal/models', 'bitbucket/internal/json-validation'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var PagedDataProvider = require("bitbucket/internal/paged-data-provider");
var models = require("bitbucket/internal/models");
var validator = require("bitbucket/internal/json-validation");

var RefDataProvider = (function (_PagedDataProvider) {
    function RefDataProvider(options) {
        var _get2;

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
        }

        _classCallCheck(this, RefDataProvider);

        options.jsonDescriptor = [models.ref];
        options.filterDescriptor = {
            term: "string?",
            repository: models.repository,
            type: validator.asEnum("RefType", models.RefType)
        };
        (_get2 = _get(Object.getPrototypeOf(RefDataProvider.prototype), "constructor", this)).call.apply(_get2, [this, options].concat(args));
    }

    _inherits(RefDataProvider, _PagedDataProvider);

    return RefDataProvider;
})(PagedDataProvider);

module.exports = RefDataProvider;

});
