# bitbucket-pull-request-table

> Pull Request table component for displaying a list of pull requests in a repo

## Installation

```
> bower install --save bitbucket-pull-request-table
```

## Usage

The `bitbucket-pull-request-table` component creates a table of pull requests and appends it to the DOM `el`.

The `options` object needs to contain a list of pull requests which is used by the bitbucket.component.pullRequestTable.main
Soy template to render the table and the table rows. The AvatarList component (used to display PR reviewers) is also
initialised here.

## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt test
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 1.7.0

- Remove Create pull request button from getting started page

### 1.6.0

- Add _moveFocus override.
- Merging PR Table defaults in to  PagedTable defaults to get nested objects
- Add paged-table class to the table to get focus styles for free

### 1.5.0

Adds all fetched message, which is passed to bitbucket-paged-table

### 1.4.0

Adds getting started intro when there are no pull requests

### 1.3.0

Adds plugin points in the table to render additional columns before and after the reviewers list. Used for comment count, task count and build status

### 1.2.0

Updates dependency versions for bitbucket-avatars, bitbucket-avatar-list, bitbucket-global-styles and jquery

### 1.0.0

Pulls in the bitbucket-time component and provides a custom mapping of i18n keys to strings to 
render pull request updated relative timestamps

### 0.1.0

Initial release
