// This file was automatically generated from index.soy.
// Please don't edit this file by hand.

/**
 * @fileoverview Templates in namespace bitbucket.component.pullRequestList.
 */

if (typeof bitbucket == 'undefined') { var bitbucket = {}; }
if (typeof bitbucket.component == 'undefined') { bitbucket.component = {}; }
if (typeof bitbucket.component.pullRequestList == 'undefined') { bitbucket.component.pullRequestList = {}; }


bitbucket.component.pullRequestList.authorSelection = function(opt_data, opt_ignored) {
  return '' + bitbucket.component.avatars.avatarWithName({person: opt_data.author, size: 'xsmall', extraClasses: 'pull-request-list-filter filter-selection'});
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestList.authorSelection.soyTemplateName = 'bitbucket.component.pullRequestList.authorSelection';
}


bitbucket.component.pullRequestList.authorResult = function(opt_data, opt_ignored) {
  return bitbucket.component.avatars.avatarWithName({person: opt_data.author, size: 'small', extraClasses: 'pull-request-list-filter filter-result'}) + '<span class="email-address">' + soy.$$escapeHtml(opt_data.author.email_address) + '</span>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestList.authorResult.soyTemplateName = 'bitbucket.component.pullRequestList.authorResult';
}


bitbucket.component.pullRequestList.targetBranchSelection = function(opt_data, opt_ignored) {
  return '<span class="pull-request-list-filter filter-selection"><span class="aui-icon aui-icon-small aui-iconfont-devtools-branch">' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.component.pull.request.list.branch')) + '</span><span class="name" title="' + soy.$$escapeHtml(opt_data.branch.display_id) + '">' + soy.$$escapeHtml(opt_data.branch.display_id) + '</span></span>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestList.targetBranchSelection.soyTemplateName = 'bitbucket.component.pullRequestList.targetBranchSelection';
}


bitbucket.component.pullRequestList.targetBranchResult = function(opt_data, opt_ignored) {
  return '<span class="pull-request-list-filter filter-result"><span class="aui-icon aui-icon-small aui-iconfont-devtools-branch">' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.component.pull.request.list.branch')) + '</span><span class="name" title="' + soy.$$escapeHtml(opt_data.branch.display_id) + '">' + soy.$$escapeHtml(opt_data.branch.display_id) + '</span></span>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestList.targetBranchResult.soyTemplateName = 'bitbucket.component.pullRequestList.targetBranchResult';
}

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/widget', 'bitbucket/internal/filter-bar', 'bitbucket/internal/pull-request-table', 'bitbucket/internal/data-provider/pull-request-list', 'bitbucket/internal/user-data-provider', 'bitbucket/internal/ref-data-provider', 'bitbucket/internal/models', 'aui', 'jquery'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/pull-request-list', ['exports', 'module', 'bitbucket/internal/widget', 'bitbucket/internal/filter-bar', 'bitbucket/internal/pull-request-table', 'bitbucket/internal/data-provider/pull-request-list', 'bitbucket/internal/user-data-provider', 'bitbucket/internal/ref-data-provider', 'bitbucket/internal/models', 'aui', 'jquery'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var Widget = require("bitbucket/internal/widget");
var FilterBar = require("bitbucket/internal/filter-bar");
var PullRequestTable = require("bitbucket/internal/pull-request-table");
var PullRequestListDataProvider = require("bitbucket/internal/data-provider/pull-request-list");
var UserDataProvider = require("bitbucket/internal/user-data-provider");
var RefDataProvider = require("bitbucket/internal/ref-data-provider");
var models = require("bitbucket/internal/models");
var AJS = require("aui");
var $ = require("jquery");

var PullRequestList = (function (_Widget) {
    /**
     * @param {jQuery|HTMLElement} el
     * @param {Object} options
     * @param {Repository?} options.repository
     * @param {User?} options.currentUser
     * @param {Array<PullRequest>?} options.initialData - if you'd like to pass in a prefetched page of PRs, this is it.
     * @param {Object?} options.filter
     * @param {boolean} options.filter.reviewer_self - true to filter to just ones where the current user is a reviewer.
     * @param {models.PullRequestState?} options.filter.state
     * @param {Ref?} options.selectedTargetBranch
     * @param {Participant?} options.selectedAuthor
     */

    function PullRequestList(el, options) {
        var _this = this;

        _classCallCheck(this, PullRequestList);

        _get(Object.getPrototypeOf(PullRequestList.prototype), "constructor", this).call(this, options);

        options.filter = options.filter || {};
        options.filter.author_id = options.selectedAuthor && options.selectedAuthor.name;
        options.filter.target_ref_id = options.selectedTargetBranch && options.selectedTargetBranch.id;

        // we probably should make this reusable, but since this is the only place that needs it, I've punted on doing that for now.
        // The next person who want sto do preloading should extract this into something shareable (e.g., perhaps some kind of mixin instead of inheriting from the user-specific provider)

        var PreloadingUserDataProvider = (function (_UserDataProvider) {
            function PreloadingUserDataProvider(options) {
                var _get2;

                for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                    args[_key - 1] = arguments[_key];
                }

                _classCallCheck(this, PreloadingUserDataProvider);

                (_get2 = _get(Object.getPrototypeOf(PreloadingUserDataProvider.prototype), "constructor", this)).call.apply(_get2, [this, options].concat(args));

                this._preloaded = false;
                this._preloadItems = options.preload || [];
                this._equalityCheck = options.equals || function (a, b) {
                    return a.id === b.id;
                };
            }

            _inherits(PreloadingUserDataProvider, _UserDataProvider);

            _createClass(PreloadingUserDataProvider, {
                reset: {
                    value: function reset() {
                        this._preloaded = false;
                        return _get(Object.getPrototypeOf(PreloadingUserDataProvider.prototype), "reset", this).call(this);
                    }
                },
                _fetchNext: {
                    value: function _fetchNext(lastResponseData) {
                        if (!this._preloaded) {
                            if (this.filter.term) {
                                this._preloaded = true;
                            } else {
                                var promise = $.Deferred().resolve(this._preloadItems);
                                promise.abort = $.noop;
                                return promise;
                            }
                        }

                        return _get(Object.getPrototypeOf(PreloadingUserDataProvider.prototype), "_fetchNext", this).call(this, lastResponseData === this._preloadItems ? null : lastResponseData);
                    }
                },
                _transform: {
                    value: function _transform(data) {
                        if (!this._preloaded) {
                            this._preloaded = true;
                            return this._preloadItems;
                        }

                        var equals = this._equalityCheck;
                        var preloadItems = this._preloadItems;
                        var out = _get(Object.getPrototypeOf(PreloadingUserDataProvider.prototype), "_transform", this).call(this, data);
                        if (this.filter.term) {
                            return out;
                        } else {
                            // if we're not filtering, exclude the preloaded items
                            return out.filter(function (item) {
                                return !preloadItems.some(function (preloadItem) {
                                    return equals(preloadItem, item);
                                });
                            });
                        }
                    }
                }
            });

            return PreloadingUserDataProvider;
        })(UserDataProvider);

        var authorProvider = new PreloadingUserDataProvider({
            preload: [options.currentUser],
            equals: function equals(a, b) {
                return a.name === b.name;
            },
            filter: {
                permissions: [{
                    name: "REPO_READ",
                    repository_id: options.repository.id
                }]
            }
        });

        var branchProvider = new RefDataProvider({
            filter: {
                repository: options.repository,
                type: "branch"
            }
        });

        var prProvider = new PullRequestListDataProvider({
            repository: options.repository.id,
            filter: {
                state: options.filter.state || models.PullRequestState.OPEN,
                author_id: options.filter.author_id || null,
                target_ref_id: options.filter.target_ref_id || null,
                reviewer_id: options.filter.reviewer_self ? options.currentUser.name : null
            }
        }, options.initialData);

        var pullRequestListFilters = [{
            id: "pr-state-filter",
            type: FilterBar.Types.SELECT,
            text: AJS.I18n.getText("bitbucket.component.pull.request.list.state"),
            value: options.filter.state,
            menu: {
                items: [{ id: models.PullRequestState.OPEN, text: AJS.I18n.getText("bitbucket.component.pull.request.list.state.open") }, { id: models.PullRequestState.MERGED, text: AJS.I18n.getText("bitbucket.component.pull.request.list.state.merged") }, { id: models.PullRequestState.DECLINED, text: AJS.I18n.getText("bitbucket.component.pull.request.list.state.declined") }]
            }
        }, {
            type: FilterBar.Types.SELECT,
            text: AJS.I18n.getText("bitbucket.component.pull.request.list.author"),
            id: "pr-author-filter",
            value: options.filter.author_id || null,
            searchPlaceholder: AJS.I18n.getText("bitbucket.component.pull.request.list.search.author"),
            menu: {
                dataProvider: authorProvider,
                id: function id(user) {
                    return user.name;
                },
                initSelection: function initSelection($el, callback) {
                    var username = $el.val();
                    if (options.filter.author_id === username) {
                        return callback(options.selectedAuthor);
                    }
                    throw new Error("Unexpected value '" + username + "' when initializing the author filter.");
                },
                formatSelection: function formatSelection(author, container) {
                    return bitbucket.component.pullRequestList.authorSelection({ author: author });
                },
                formatResult: function formatResult(author, container) {
                    return bitbucket.component.pullRequestList.authorResult({ author: author });
                },
                formatNoMatches: function formatNoMatches() {
                    return AJS.I18n.getText("bitbucket.component.pull.request.list.search.author.nomatches");
                },
                placeholder: AJS.I18n.getText("bitbucket.component.pull.request.list.author"),
                dropdownCssClass: "pr-author-dropdown"
            }
        }, {
            type: FilterBar.Types.SELECT,
            text: AJS.I18n.getText("bitbucket.component.pull.request.list.branch.target"),
            id: "pr-target-branch-filter",
            value: options.filter.target_ref_id || null,
            searchPlaceholder: AJS.I18n.getText("bitbucket.component.pull.request.list.search.branch"),
            menu: {
                dataProvider: branchProvider,
                initSelection: function initSelection($el, callback) {
                    var branch = $el.val();
                    if (options.filter.target_ref_id === branch) {
                        return callback(options.selectedTargetBranch);
                    }
                    throw new Error("Unexpected value '" + branch + "' when initializing the target branch filter.");
                },
                formatSelection: function formatSelection(branch, container) {
                    return bitbucket.component.pullRequestList.targetBranchSelection({ branch: branch });
                },
                formatResult: function formatResult(branch, container) {
                    return bitbucket.component.pullRequestList.targetBranchResult({ branch: branch });
                },
                formatNoMatches: function formatNoMatches() {
                    return AJS.I18n.getText("bitbucket.component.pull.request.list.search.branch.nomatches");
                },
                placeholder: AJS.I18n.getText("bitbucket.component.pull.request.list.branch.target"),
                dropdownCssClass: "pr-target-branch-dropdown"
            }
        }];

        if (options.currentUser) {
            // anonymous users shouldn't see the "I'm reviewing"
            pullRequestListFilters.push({
                type: FilterBar.Types.TOGGLE,
                text: AJS.I18n.getText("bitbucket.component.pull.request.list.reviewer.self"),
                id: "pr-reviewer-self-filter",
                value: options.filter.reviewer_self
            });
        }

        var filterBar = new FilterBar(el, {
            id: "pull-requests-filter-bar",
            filters: pullRequestListFilters
        });

        this.pullRequestTable = new PullRequestTable(el, {
            id: "pull-requests-table",
            dataProvider: prProvider,
            isFiltered: function () {
                var filter = prProvider.filter;
                return filter.state !== "OPEN" || filter.author_id || filter.target_ref_id || filter.reviewer_id;
            },
            repository: options.repository
        });

        this.pullRequestTable.init();
        filterBar.on("change", function () {
            var filterState = filterBar.state;
            var cleanState = {
                state: filterState["pr-state-filter"],
                author_id: filterState["pr-author-filter"] || null,
                target_ref_id: filterState["pr-target-branch-filter"] || null,
                reviewer_self: filterState["pr-reviewer-self-filter"]
            };

            prProvider.setFilter("state", cleanState.state);
            prProvider.setFilter("author_id", cleanState.author_id);
            prProvider.setFilter("target_ref_id", cleanState.target_ref_id);
            prProvider.setFilter("reviewer_id", cleanState.reviewer_self ? options.currentUser.name : null);
            prProvider.reset();

            _this.trigger("state-change", cleanState);
        });

        // if there isn't a focused row set focus to the inital row in the table.
        var focusInitialRowIfNeeded = function () {
            if (!_this.pullRequestTable._getFocusedItem().length) {
                _this.pullRequestTable.focusInitialRow();
            }
        };
        // when a page is rendered, check if we need to focus the initial row.
        this.pullRequestTable.on("page-rendered", focusInitialRowIfNeeded);
        focusInitialRowIfNeeded();
    }

    _inherits(PullRequestList, _Widget);

    _createClass(PullRequestList, {
        _keyboardActions: {
            get: function () {
                return {
                    moveNext: this.pullRequestTable.moveNext,
                    movePrevious: this.pullRequestTable.movePrevious,
                    openItem: this.pullRequestTable.openItem
                };
            }
        },
        getKeyboardAction: {
            value: function getKeyboardAction(action) {
                var kbdAction = this._keyboardActions[action];
                if (typeof kbdAction === "function") {
                    return kbdAction;
                }
                throw new Error("No keyboard action has been defined for '" + action + "'.");
            }
        }
    });

    return PullRequestList;
})(Widget);

var index = PullRequestList;

module.exports = index;

});
