// bind polyfill for PhantomJS from MDN:
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind
//
// (Public Domain as per https://developer.mozilla.org/en-US/docs/MDN/About#Copyrights_and_licenses)
if (!Function.prototype.bind) {
	Function.prototype.bind = function (oThis) {
		if (typeof this !== "function") {
			// closest thing possible to the ECMAScript 5 internal IsCallable function
			throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");
		}

		var aArgs = Array.prototype.slice.call(arguments, 1),
			fToBind = this,
			fNOP = function () {},
			fBound = function () {
				return fToBind.apply(this instanceof fNOP && oThis
						? this
						: oThis,
					aArgs.concat(Array.prototype.slice.call(arguments)));
			};

		fNOP.prototype = this.prototype;
		fBound.prototype = new fNOP();

		return fBound;
	};
}

var allTestModules = [];
var TEST_REGEXP = /^\/base\/tests.*?(spec|test)\.js$/i;

var pathToModule = function(path) {
	if (/^\/absolute/.test(path)) {
		return path.replace(/\\/g, '/');
	}
	return path.replace(/^\/base\//, '').replace(/\.js$/, '').replace(/\\/g, '/');
};

Object.keys(window.__karma__.files).forEach(function(file) {
	if (TEST_REGEXP.test(file)) {
		// Normalize paths to RequireJS module names.
		allTestModules.push(pathToModule(file));
	}
});

var karmaStarted = false;

var requireConfig = {
	// Karma serves files under /base, which is the basePath from your config file
	baseUrl: '/base',

	// we have to kickoff Require, as it is asynchronous
	callback: function () {
		var self = this;
		// when loading tests containing Squire this callback could fire multiple times as each
		// Squire instance creates a Require context
		if (!karmaStarted) {
			karmaStarted = true;

			// load all the actual test files here..
			var loadTestsAndStart = require.bind(null, allTestModules, function() {
				// Introduce a delay as when using Squire some test files load asynchronously,
				// this allows us to get a correct test count.
				setTimeout(window.__karma__.start, 200);
			});

			var preloadedModules = [];
			// Comment/uncomment preloadedModules lines as needed.
			preloadedModules.push('soyutils');

			if (preloadedModules.length) {
				require(preloadedModules, function() {
					loadTestsAndStart();
				});
			} else {
				loadTestsAndStart();
			}
		}
    },
	paths: {
		// generic modules that are probably going to be required by tests
		'aui': 'bower_components/aui-adg-dist/aui/js/aui',
		'backbone': 'bower_components/backbone/backbone',
		'backbone-brace': 'bower_components/backbone-brace/dist/backbone.brace',
		'bacon': 'bower_components/bacon/dist/Bacon',
		'eevee': 'bower_components/eevee/lib/eevee',
		'eve': 'bower_components/eve-adobe/eve',
		'jquery': 'bower_components/jquery/dist/jquery',
		'internal/util/function': 'bower_components/atlassian-functional/lib/internal/util/function',
		'internal/util/navigator': 'bower_components/atlassian-navigator/lib/internal/util/navigator',
		'lodash': 'bower_components/lodash/lodash',
		'underscore': 'bower_components/underscore/underscore',
		'bitbucket/internal/utils': 'bower_components/utils/dist',
		'soyutils': 'bower_components/bitbucket-soy-functions/soyutils'
	},
	shim: {
		'aui': {
			deps: ['jquery'],
			init: function () {
				return AJS;
			}
		},
		'backbone-brace' : {
            deps : ['backbone'],
            exports : 'Brace'
        },
	}
};

// Adds modules found in bower_components and the module under test to paths
Object.keys(window.__karma__.config.componentModules).forEach(function (moduleName) {
	requireConfig.paths[moduleName] = window.__karma__.config.componentModules[moduleName].replace(/\\/g, '/');
});

require.config(requireConfig);
