define('bitbucket/internal/urls', [
    'bitbucket/util/navbuilder',
    'bitbucket/internal/javascript-errors',
    'bitbucket/internal/spi/urls',
    'bitbucket/internal/util/object'
], function (
    nav,
    errors,
    UrlsSPI,
    obj
) {
    'use strict';

    function Urls () {
        UrlsSPI.call(this);
    }

    obj.inherits(Urls, UrlsSPI);

    var fileChanges = function (repository, commitRange) {
        //throw new NotImplementedError();
    };

    Urls.prototype.avatarUrl = function (person, size) {
        var stashPerson = {
            avatarUrl: person.avatar_url
        };
        return nav._avatarUrl(stashPerson, size).build();
    };

    Urls.prototype.pullRequest = function (pullRequest) {
        return nav.currentRepo().pullRequest(pullRequest).build();
    };

    Urls.prototype.createPullRequest = function(repository){
        return nav.project(repository.project).repo(repository).createPullRequest().build();
    };

    Urls.prototype.allPullRequests = function(repository){
        return nav.project(repository.project).repo(repository).allPullRequests().build();
    };

    Urls.prototype.help = function(key) {
        switch(key) {
            case 'help.pull.request':
                return bitbucket_help_url('bitbucket.help.pull.request');
            default:
                throw new errors.NotImplementedError();
        }
    };

    return new Urls();
});
