import Widget from 'bitbucket/internal/widget';
import FilterBar from 'bitbucket/internal/filter-bar';
import PullRequestTable from 'bitbucket/internal/pull-request-table';

class PullRequestList extends Widget {
    /**
     * @param {jQuery|HTMLElement} el
     * @param {Object} options
     */
    constructor(el, options) {
        super(options);

        var pullRequestListFilters = [
            {
                type: 'select',
                text: 'Open',
                id: 'pr-status',
                menu: {
                    id: 'pr-filter-status-menu',
                    dataProvider:  [
                        {value: 'open', displayName: 'Open'},
                        {value: 'merged', displayName: 'Merged'},
                        {value: 'declined', displayName: 'Declined'}
                    ]
                }
            }, {
                type: 'toggle',
                text: 'Author',
                id: 'pr-author'
            }, {
                type: 'toggle',
                text: 'Target branch',
                id: 'pr-target-branch'
            }, {
                type: 'toggle',
                text: 'Reviewer is me',
                id: 'pr-filter-author-self'
            }
        ];

        var filterBar = new FilterBar(el, {
            id: 'pull-requests-filter-bar',
            filters: pullRequestListFilters
        });

        var pullRequestTable = new PullRequestTable(el, {
            id: 'pull-requests-table',
            data: options.tableData
        });
    }
}

export default PullRequestList;