(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/widget', 'bitbucket/internal/filter-bar', 'bitbucket/internal/pull-request-table'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/pull-request-list', ['exports', 'module', 'bitbucket/internal/widget', 'bitbucket/internal/filter-bar', 'bitbucket/internal/pull-request-table'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var Widget = require("bitbucket/internal/widget");
var FilterBar = require("bitbucket/internal/filter-bar");
var PullRequestTable = require("bitbucket/internal/pull-request-table");

var PullRequestList = (function (_Widget) {
    /**
     * @param {jQuery|HTMLElement} el
     * @param {Object} options
     */

    function PullRequestList(el, options) {
        _classCallCheck(this, PullRequestList);

        _get(Object.getPrototypeOf(PullRequestList.prototype), "constructor", this).call(this, options);

        var pullRequestListFilters = [{
            type: "select",
            text: "Open",
            id: "pr-status",
            menu: {
                id: "pr-filter-status-menu",
                dataProvider: [{ value: "open", displayName: "Open" }, { value: "merged", displayName: "Merged" }, { value: "declined", displayName: "Declined" }]
            }
        }, {
            type: "toggle",
            text: "Author",
            id: "pr-author"
        }, {
            type: "toggle",
            text: "Target branch",
            id: "pr-target-branch"
        }, {
            type: "toggle",
            text: "Reviewer is me",
            id: "pr-filter-author-self"
        }];

        var filterBar = new FilterBar(el, {
            id: "pull-requests-filter-bar",
            filters: pullRequestListFilters
        });

        var pullRequestTable = new PullRequestTable(el, {
            id: "pull-requests-table",
            data: options.tableData
        });
    }

    _inherits(PullRequestList, _Widget);

    return PullRequestList;
})(Widget);

var index = PullRequestList;

module.exports = index;

});
