import Widget from 'bitbucket/internal/widget';
import $ from 'jquery';

class FilterBar extends Widget {
    /**
     * @param {jQuery|HTMLElement} el
     * @param {Object} options
     */
    constructor(el, options) {
        super(options);

        // TODO: use a better way to append/replace content of placeholder?
        $(el).append(
            bitbucket.component.filterBar.main({
                id: options.id,
                filters: options.filters
            })
        );

        $(el).find('select').each(function() {
            $(this).auiSelect2({
                minimumResultsForSearch: -1 // don't show the search box. TODO: make this configurable per-filter
            });
        });

        this.onChange(el);
    };

    onChange(el) {
        $(el).on('change', (e) => {
            this.trigger('changed');
        });
    }

}

export default FilterBar;