define('bitbucket/internal/page/users/profile', [
    'jquery',
    'bitbucket/internal/util/notifications',
    'bitbucket/internal/feature/repository/repository-table',
    'exports'
], function (
    $,
    notifications,
    RepositoryTable,
    exports
) {
    'use strict';

    exports.onReady = function(repositoryTableSelector, personalProjectKey, isOwnProfile, userDisplayName, isPersonalRepositoryEnabled) {
        // Attach flash notifications. Can be result of deleted repositories
        notifications.showFlashes();

        var repositoryTableParams = {
            projectKey: personalProjectKey,
            showPublicStatus: true,
            noneFoundMessageHtml: isOwnProfile ?
                bitbucket.internal.users.profile.noRepositoriesSelf({projectKey: personalProjectKey}) :
                bitbucket.internal.users.profile.noRepositories({userDisplayName: userDisplayName}),
            bufferPixels: $('#footer').height()
        };

        if (!isPersonalRepositoryEnabled) {
            repositoryTableParams.noneFoundMessageHtml = bitbucket.internal.users.profile.personalRepositoryDisabled();
        }

        new RepositoryTable(repositoryTableSelector, repositoryTableParams).init();
    };
});
