define('bitbucket/internal/page/repository-fork', [
    'jquery',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/model/repository',
    'bitbucket/internal/feature/project/project-selector',
    'bitbucket/internal/feature/repository/cloneUrlGen',
    'exports'
], function (
    $,
    pageState,
    Repository,
    ProjectSelector,
    cloneUrlGen,
    exports
) {
    'use strict';

    function initRepositoryPageState(repositoryJson) {
        var repo = new Repository(repositoryJson);
        pageState.setRepository(repo);
        pageState.setProject(repo.getProject());
    }

    function initProjectSelector(projectSelectorSelector, personalProjectJson) {
        var $projectTrigger = $(projectSelectorSelector);
        var $projectInput = $projectTrigger.next('input');
        var $preloadData = personalProjectJson ? [personalProjectJson] : null;
        return new ProjectSelector($projectTrigger, {
            field: $projectInput,
            preloadData: ProjectSelector.constructDataPageFromPreloadArray($preloadData)
        });
    }

    exports.onReady = function (repositoryJson, projectSelectorSelector, personalProjectJson) {
        initRepositoryPageState(repositoryJson);
        var projectSelector = initProjectSelector(projectSelectorSelector, personalProjectJson);

        var $repoName = $("#name");
        var $cloneUrl = $repoName.next('.description').find('.clone-url > span');

        cloneUrlGen.bindUrlGeneration($cloneUrl, {
            elementsToWatch: [$repoName, projectSelectorSelector],
            getProject: projectSelector.getSelectedItem.bind(projectSelector),
            getRepoName: $repoName.val.bind($repoName)
        });
    };
});
