define('bitbucket/internal/page/repository-create', [
    'jquery',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/model/project',
    'bitbucket/internal/feature/repository/cloneUrlGen',
    'exports'
], function(
    $,
    pageState,
    Project,
    cloneUrlGen,
    exports
) {
    exports.onReady = function(projectJSON) {
        pageState.setProject(new Project(projectJSON));

        var $repoName = $("#name");
        var $cloneUrl = $repoName.next(".description").find(".clone_url > span");
        cloneUrlGen.bindUrlGeneration($cloneUrl, {
            elementsToWatch: [$repoName],
            getRepoName: $repoName.val.bind($repoName)
        });
    };
});
