define('bitbucket/internal/page/pull-requests-list', [
    'bitbucket/util/navbuilder',
    'bitbucket/internal/util/events',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/widget/avatar-list',
    'bitbucket/internal/feature/pull-request/pull-request-table',
    'exports'
], function (
    nav,
    events,
    pageState,
    AvatarList,
    PullRequestsTable,
    exports
) {
    'use strict';
    var pullRequestTable;

    function getPullRequestsUrlBuilder(state) {
        return nav.rest().currentRepo().allPullRequests().withParams({ state: state });
    }

    function bindKeyboardShortcuts() {
        pullRequestTable.initShortcuts();

        events.on('bitbucket.internal.widget.keyboard-shortcuts.register-contexts', function (keyboardShortcuts) {
            keyboardShortcuts.enableContext('pull-request-list');
        });

        events.on('bitbucket.internal.keyboard.shortcuts.requestMoveToNextHandler', pullRequestTable.bindMoveToNextHandler);
        events.on('bitbucket.internal.keyboard.shortcuts.requestMoveToPreviousHandler', pullRequestTable.bindMoveToPreviousHandler);
        events.on('bitbucket.internal.keyboard.shortcuts.requestOpenItemHandler', pullRequestTable.bindOpenItemHandler);
        events.on('bitbucket.internal.keyboard.shortcuts.pullrequest.requestHighlightAssignedHandler', pullRequestTable.bindHighlightAssignedHandler);
    }

    exports.onReady = function (state, order, initialData) {
        pullRequestTable = new PullRequestsTable(state, order, getPullRequestsUrlBuilder, {
            noneFoundMessageHtml: bitbucket.internal.feature.pullRequest.pullRequestIntro({ repository: pageState.getRepository().toJSON(),
                state: state
            }),
			initialData: initialData
        });
        pullRequestTable.init();
        AvatarList.init();

        bindKeyboardShortcuts();
    };
});
