define('bitbucket/internal/page/admin/usersList', [
    'aui',
    'bitbucket/internal/util/notifications',
    'bitbucket/internal/widget/delete-dialog',
    'bitbucket/internal/feature/user/user-table',
    'exports'
], function(
    AJS,
    notifications,
    deleteDialog,
    UserTable,
    exports) {

    exports.onReady = function(tableSelector, deleteLinksSelector) {

        notifications.showFlashes();

        var userTable = new UserTable({
            target : tableSelector
        });

        userTable.init();

        // confirm dialog to delete groups
        deleteDialog.bind(deleteLinksSelector,
            AJS.I18n.getText('stash.web.user.delete'),
            AJS.I18n.getText('stash.web.user.delete.success'),
            AJS.I18n.getText('stash.web.user.delete.fail'),
            function(displayName) {
                notifications.addFlash(AJS.I18n.getText('stash.web.user.delete.success', displayName));
                location.reload();
            }
        );
    };
});