define('bitbucket/internal/feature/pull-request/can-merge', [
    'bitbucket/util/navbuilder',
    'bitbucket/internal/util/ajax',
    'bitbucket/internal/util/events',
    'bitbucket/internal/model/page-state'
], function(
    nav,
    ajax,
    events,
    pageState
) {

    function canMerge(pullRequest){
         pullRequest = pullRequest || pageState.getPullRequest();

         return ajax.rest({
             url: nav.rest()
                 .currentRepo()
                 .pullRequest(pullRequest.getId())
                 .merge()
                 .build(),
             type: 'GET'
         }).done(function(data) {
            events.trigger(data.canMerge ? 'bitbucket.internal.pull-request.can.merge' : 'bitbucket.internal.pull-request.cant.merge', null, pullRequest, data.conflicted, data.vetoes, data.properties);
         });
     }

    return canMerge;
});
