/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.http.mime.UserAgentUtil;
import com.atlassian.http.mime.UserAgentUtilImpl;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MatchesUserAgentCondition
implements Condition {
    private final UserAgentUtil userAgentUtil;
    private EnumSet<UserAgentUtil.BrowserFamily> browserFamilies = EnumSet.allOf(UserAgentUtil.BrowserFamily.class);
    private EnumSet<UserAgentUtil.BrowserMajorVersion> browserMajorVersions = EnumSet.allOf(UserAgentUtil.BrowserMajorVersion.class);
    private EnumSet<UserAgentUtil.OperatingSystem.OperatingSystemFamily> operatingSystemFamilies = EnumSet.allOf(UserAgentUtil.OperatingSystem.OperatingSystemFamily.class);

    public MatchesUserAgentCondition() {
        this.userAgentUtil = new UserAgentUtilImpl();
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (params.containsKey("browsers")) {
            this.browserFamilies = this.createEnumSet(params.get("browsers"), UserAgentUtil.BrowserFamily.class);
        }
        if (params.containsKey("browserVersions")) {
            this.browserMajorVersions = this.createEnumSet(params.get("browserVersions"), UserAgentUtil.BrowserMajorVersion.class);
        }
        if (params.containsKey("operatingSystems")) {
            this.operatingSystemFamilies = this.createEnumSet(params.get("operatingSystems"), UserAgentUtil.OperatingSystem.OperatingSystemFamily.class);
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Object request = context.get("request");
        return request instanceof HttpServletRequest && this.matchesUserAgent(((HttpServletRequest)request).getHeader("user-agent"));
    }

    private <T extends Enum<T>> EnumSet<T> createEnumSet(String value, Class<T> enumClass) throws PluginParseException {
        String[] values = value.split(",");
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (String s : values) {
            try {
                list.add(Enum.valueOf(enumClass, s));
            }
            catch (IllegalArgumentException e) {
                throw new PluginParseException((Throwable)e);
            }
        }
        return EnumSet.copyOf(list);
    }

    private boolean matchesUserAgent(String userAgentString) {
        UserAgentUtil.UserAgent userAgent = this.userAgentUtil.getUserAgentInfo(userAgentString);
        UserAgentUtil.Browser browser = userAgent.getBrowser();
        UserAgentUtil.OperatingSystem operatingSystem = userAgent.getOperatingSystem();
        return this.browserFamilies.contains(browser.getBrowserFamily()) && this.browserMajorVersions.contains(browser.getBrowserMajorVersion()) && this.operatingSystemFamilies.contains(operatingSystem.getOperatingSystemFamily());
    }
}

