/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class IsApplicationVersionCondition
implements Condition {
    private static final String VERSION_PARAM = "version";
    private static final String OPERATOR_PARAM = "operator";
    private final ApplicationPropertiesService applicationPropertiesService;
    private Operator operator;
    private Version testVersion;

    public IsApplicationVersionCondition(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.operator = this.getOperator(params);
        this.testVersion = this.getVersion(params);
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String stashVersionString = this.applicationPropertiesService.getBuildVersion();
        Version stashVersion = new Version(stashVersionString);
        return this.operator.test(stashVersion.compareTo(this.testVersion));
    }

    private Version getVersion(Map<String, String> params) {
        String stringVersion = params.get(VERSION_PARAM);
        if (stringVersion == null) {
            throw new PluginParseException("Required parameter 'version' missing");
        }
        if (!Version.STRICT_NUMERIC_VALIDATOR.matcher(stringVersion).matches()) {
            throw new PluginParseException("Invalid version: " + stringVersion);
        }
        return new Version(stringVersion);
    }

    private Operator getOperator(Map<String, String> params) {
        String stringOperator = params.get(OPERATOR_PARAM);
        if (stringOperator == null) {
            throw new PluginParseException("Required parameter 'operator' missing");
        }
        try {
            return Operator.valueOf(stringOperator.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("Invalid operator: " + stringOperator);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Operator {
        EQ{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult == 0;
            }
        }
        ,
        NEQ{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult != 0;
            }
        }
        ,
        GT{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult > 0;
            }
        }
        ,
        GTE{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult >= 0;
            }
        }
        ,
        LT{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult < 0;
            }
        }
        ,
        LTE{

            @Override
            public boolean test(int compareToResult) {
                return compareToResult <= 0;
            }
        };


        public abstract boolean test(int var1);
    }
}

