/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Set;

public class CanCloneRepositoryCondition
implements Condition {
    private final PermissionService permissionService;
    private final RepositoryService repositoryService;

    public CanCloneRepositoryCondition(PermissionService permissionService, RepositoryService repositoryService) {
        this.permissionService = permissionService;
        this.repositoryService = repositoryService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)context.get("repository");
        if (repository == null) {
            return false;
        }
        if (!this.permissionService.isRepositoryAccessible(repository)) {
            return false;
        }
        RepositoryCloneLinksRequest cloneLinksRequest = new RepositoryCloneLinksRequest.Builder().repository(repository).build();
        Set cloneUrls = this.repositoryService.getCloneLinks(cloneLinksRequest);
        return !cloneUrls.isEmpty();
    }
}

