/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPermissionCondition
implements Condition {
    public static final String PERMISSION = "permission";
    public static final String CONTEXT_PARAM = "contextParam";
    protected final PermissionService permissionService;
    private final boolean global;
    private Permission permission;
    private String contextParam;

    protected AbstractPermissionCondition(PermissionService permissionService, boolean global) {
        this.global = global;
        this.permissionService = permissionService;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String permissionName = params.get(PERMISSION);
        if (StringUtils.isBlank((CharSequence)permissionName)) {
            throw new PluginParseException(this.getClass().getSimpleName() + ": The [permission] param is required, and must define a " + this.getType() + " permission");
        }
        try {
            this.permission = Permission.valueOf((String)permissionName);
            Preconditions.checkArgument((this.global == this.permission.isGlobal() ? 1 : 0) != 0, (String)"%s requires a %s permission", (Object)this.getClass().getSimpleName(), (Object)this.getType());
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(e.getMessage());
        }
        this.contextParam = params.get(CONTEXT_PARAM);
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (this.contextParam != null && context.containsKey(this.contextParam)) {
            Object userObject = context.get(this.contextParam);
            if (userObject instanceof ApplicationUser) {
                return this.hasPermission(context, (ApplicationUser)userObject);
            }
            if (userObject instanceof String) {
                return this.hasPermission(context, (String)userObject);
            }
            if (userObject instanceof Person) {
                return this.hasPermission(context, ((Person)userObject).getName());
            }
            return this.hasPermission(context, (ApplicationUser)null);
        }
        return this.hasPermission(context);
    }

    protected boolean hasPermission(Map<String, Object> context) {
        return false;
    }

    protected boolean hasPermission(Map<String, Object> context, ApplicationUser user) {
        return false;
    }

    protected boolean hasPermission(Map<String, Object> context, String userName) {
        return false;
    }

    protected String getType() {
        return this.global ? "global" : "non-global";
    }
}

