/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IsFeatureEnabledCondition
implements Condition {
    static final String KEY = "key";
    private final FeatureManager featureManager;
    private StandardFeature feature;

    public IsFeatureEnabledCondition(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    protected IsFeatureEnabledCondition(FeatureManager featureManager, StandardFeature feature) {
        this.featureManager = featureManager;
        this.feature = (StandardFeature)Preconditions.checkNotNull((Object)feature, (Object)"feature");
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (this.feature == null) {
            String featureKeyAsString = params.get(KEY);
            if (StringUtils.isBlank((CharSequence)featureKeyAsString)) {
                throw new PluginParseException(this.getClass().getSimpleName() + " requires the parameter " + KEY);
            }
            this.feature = StandardFeature.fromKey((String)featureKeyAsString);
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.featureManager.isEnabled((Feature)this.feature);
    }
}

