/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util.concurrent;

import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gate<T> {
    private static final Logger log = LoggerFactory.getLogger(Gate.class);
    private static final int CLEANUP_THRESHOLD = 1500;
    private final long minTimeBetweenCallsMillis;
    private final long minTimeBetweenCallsNanos;
    private final ConcurrentMap<T, Long> timestampsByKey;
    private final ReentrantLock lock;

    public Gate(long minTimeBetweenCalls, TimeUnit timeUnit) {
        this.minTimeBetweenCallsMillis = timeUnit.toMillis(minTimeBetweenCalls);
        this.minTimeBetweenCallsNanos = timeUnit.toNanos(minTimeBetweenCalls);
        this.timestampsByKey = new ConcurrentHashMap<T, Long>();
        this.lock = new ReentrantLock();
    }

    public boolean callIfNotRecentlyRun(T key, Runnable operation) {
        boolean hasRun = false;
        long now = System.nanoTime();
        long timestamp = this.timestampsByKey.compute(key, (k, lastRun) -> lastRun == null || lastRun + this.minTimeBetweenCallsNanos <= now ? now : lastRun);
        if (timestamp == now) {
            log.trace("[key={}] running operation", key);
            operation.run();
            hasRun = true;
        } else {
            log.trace("[key={}] skipping operation because it already ran in the past {} ms", key, (Object)this.minTimeBetweenCallsMillis);
        }
        if (1500 < this.timestampsByKey.size()) {
            log.trace("Cleaning up gate map");
            this.cleanup(now);
            log.trace("Cleaned up gate map. {} items remain.", (Object)this.getMapSize());
        }
        return hasRun;
    }

    private void cleanup(long now) {
        try (LockGuard guard = LockGuard.tryLock(this.lock);){
            if (guard != null) {
                this.timestampsByKey.entrySet().removeIf(entry -> (Long)entry.getValue() + this.minTimeBetweenCallsNanos <= now);
            }
        }
    }

    @VisibleForTesting
    protected int getMapSize() {
        return this.timestampsByKey.size();
    }
}

