/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;

public class PagedIterable<T>
implements Iterable<T> {
    private final PageProvider<T> pageProvider;
    private final PageRequest pageRequest;

    public PagedIterable(PageProvider<T> pageProvider, int pageSize) {
        this(pageProvider, PageUtils.newRequest(0, pageSize));
    }

    public PagedIterable(PageProvider<T> pageProvider, PageRequest pageRequest) {
        this.pageProvider = pageProvider;
        this.pageRequest = pageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return new PagedIterator(this.pageProvider.get(this.pageRequest));
    }

    private class PagedIterator
    extends AbstractIterator<T> {
        private Page<T> currentPage;
        private Iterator<T> iterator;

        PagedIterator(Page<T> page) {
            this.currentPage = page;
            this.iterator = page.getValues().iterator();
        }

        protected T computeNext() {
            while (!this.iterator.hasNext()) {
                PageRequest next = this.currentPage.getNextPageRequest();
                if (next == null) {
                    return this.endOfData();
                }
                this.currentPage = PagedIterable.this.pageProvider.get(next);
                this.iterator = this.currentPage.getValues().iterator();
            }
            return this.iterator.next();
        }
    }
}

