/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util.concurrent;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(ExecutorUtils.class);
    private static final long DEFAULT_SHUTDOWN_TIME = 10L;
    private static final long DEFAULT_SHUTDOWN_NOW_TIME = 5L;
    private static final TimeUnit DEFAULT_SHUTDOWN_TIME_UNIT = TimeUnit.SECONDS;
    private static final TimeUnit DEFAULT_SHUTDOWN_NOW_TIME_UNIT = TimeUnit.SECONDS;

    private ExecutorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void shutdown(@Nonnull ExecutorService executorService) {
        ExecutorUtils.shutdown(executorService, DEFAULT_LOG);
    }

    public static void shutdown(@Nonnull ExecutorService executorService, long shutdownTime, @Nonnull TimeUnit shutdownTimeUnit, long shutdownNowTime, @Nonnull TimeUnit shutdownNowTimeUnit) {
        ExecutorUtils.shutdown(executorService, shutdownTime, shutdownTimeUnit, shutdownNowTime, shutdownNowTimeUnit, DEFAULT_LOG);
    }

    public static void shutdown(@Nonnull ExecutorService executorService, @Nonnull Logger log) {
        ExecutorUtils.shutdown(executorService, 10L, DEFAULT_SHUTDOWN_TIME_UNIT, 5L, DEFAULT_SHUTDOWN_NOW_TIME_UNIT, log);
    }

    public static void shutdown(@Nonnull ExecutorService executorService, long shutdownTime, @Nonnull TimeUnit shutdownTimeUnit, long shutdownNowTime, @Nonnull TimeUnit shutdownNowTimeUnit, @Nonnull Logger log) {
        Objects.requireNonNull(executorService, "executorService");
        shutdownTimeUnit = (TimeUnit)((Object)MoreObjects.firstNonNull((Object)((Object)shutdownTimeUnit), (Object)((Object)DEFAULT_SHUTDOWN_NOW_TIME_UNIT)));
        shutdownNowTimeUnit = (TimeUnit)((Object)MoreObjects.firstNonNull((Object)((Object)shutdownNowTimeUnit), (Object)((Object)DEFAULT_SHUTDOWN_NOW_TIME_UNIT)));
        log = (Logger)MoreObjects.firstNonNull((Object)log, (Object)DEFAULT_LOG);
        try {
            executorService.shutdown();
            if (executorService.awaitTermination(shutdownTime, shutdownTimeUnit)) {
                log.debug("Executor service has shutdown gracefully");
            } else {
                log.warn("Executor service did not shutdown within the timeout; forcing shutdown");
                executorService.shutdownNow();
                if (executorService.awaitTermination(shutdownNowTime, shutdownNowTimeUnit)) {
                    log.debug("Executor service has been forced to shutdown");
                } else {
                    log.warn("Executor service did not shutdown; it will be abandoned");
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the executor service to shutdown; some worker threads may still be running");
            Thread.currentThread().interrupt();
        }
    }
}

