/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class AuditUtils {
    @Deprecated
    public static final String ATTRIBUTE_NAME_DETAILS = "bitbucket.audit.attribute.legacy.details";
    @Deprecated
    public static final String ATTRIBUTE_NAME_TARGET = "bitbucket.audit.attribute.legacy.target";
    public static final String AUDIT_RESOURCE_TYPE_APPLINK = "APPLINK";
    public static final String AUDIT_RESOURCE_TYPE_GROUP = "GROUP";
    public static final String AUDIT_RESOURCE_TYPE_MISC = "MISC";
    public static final String AUDIT_RESOURCE_TYPE_PROJECT = "PROJECT";
    public static final String AUDIT_RESOURCE_TYPE_PULL_REQUEST = "PULL_REQUEST";
    public static final String AUDIT_RESOURCE_TYPE_REPOSITORY = "REPOSITORY";
    public static final String AUDIT_RESOURCE_TYPE_USER = "USER";
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();

    private AuditUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static ImmutableMap.Builder<String, Object> addProjectAndRepositoryToMap(@Nonnull Repository repository, ImmutableMap.Builder<String, Object> mapBuilder) {
        Objects.requireNonNull(repository, "repository");
        return mapBuilder.put((Object)"project", (Object)repository.getProject().getKey()).put((Object)"repository", (Object)repository.getSlug());
    }

    @Deprecated
    @Nonnull
    public static AuditAttribute attributeForDetails(String details) {
        return AuditAttribute.fromI18nKeys((String)ATTRIBUTE_NAME_DETAILS, (String)details).withNameTranslation(ATTRIBUTE_NAME_DETAILS).build();
    }

    @Deprecated
    @Nonnull
    public static AuditAttribute attributeForTarget(String target) {
        return AuditAttribute.fromI18nKeys((String)ATTRIBUTE_NAME_TARGET, (String)target).withNameTranslation(ATTRIBUTE_NAME_TARGET).build();
    }

    @Nonnull
    public static AuditAuthor auditAuthorForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return new AuditAuthor.Builder().id(String.valueOf(user.getId())).name(user.getName()).type(user.getType().name()).build();
    }

    @Nonnull
    public static AuditResource auditResourceForAppLink(@Nonnull ApplicationLink applicationLink) {
        Objects.requireNonNull(applicationLink, "applicationLink");
        return AuditResource.builder((String)((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{applicationLink.getName(), applicationLink.getId().get()})), (String)AUDIT_RESOURCE_TYPE_APPLINK).id(applicationLink.getId().get()).build();
    }

    @Nonnull
    public static AuditResource auditResourceForGroup(@Nonnull String group) {
        Objects.requireNonNull(group, "group");
        return AuditResource.builder((String)group, (String)AUDIT_RESOURCE_TYPE_GROUP).id(group).build();
    }

    @Nonnull
    public static AuditResource auditResourceForProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return AuditResource.builder((String)project.getKey(), (String)AUDIT_RESOURCE_TYPE_PROJECT).id(String.valueOf(project.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return AuditResource.builder((String)("PR#" + pullRequest.getId()), (String)AUDIT_RESOURCE_TYPE_PULL_REQUEST).id(AuditUtils.pullRequestResourceId(pullRequest.getToRef().getRepository().getId(), pullRequest.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return AuditResource.builder((String)repository.getSlug(), (String)AUDIT_RESOURCE_TYPE_REPOSITORY).id(String.valueOf(repository.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return AuditResource.builder((String)user.getName(), (String)AUDIT_RESOURCE_TYPE_USER).id(String.valueOf(user.getId())).build();
    }

    @Nonnull
    public static List<AuditResource> auditResourcesForProjectAndRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return ImmutableList.of((Object)AuditUtils.auditResourceForProject(repository.getProject()), (Object)AuditUtils.auditResourceForRepository(repository));
    }

    @Nonnull
    public static List<AuditResource> auditResourcesForProjectRepositoryPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Repository repository = pullRequest.getToRef().getRepository();
        return ImmutableList.of((Object)AuditUtils.auditResourceForPullRequest(pullRequest), (Object)AuditUtils.auditResourceForRepository(repository), (Object)AuditUtils.auditResourceForProject(repository.getProject()));
    }

    @Nonnull
    public static AuditResource miscellaneousAuditResource(@Nonnull String name) {
        return AuditResource.builder((String)Objects.requireNonNull(name, "name"), (String)AUDIT_RESOURCE_TYPE_MISC).build();
    }

    public static String toJSONString(@Nullable Map<String, Object> value) throws IOException {
        return AuditUtils.toJsonInternal(value);
    }

    public static String toJson(@Nullable Object value) {
        try {
            return AuditUtils.toJsonInternal(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert object %s to JSON", value), e);
        }
    }

    public static String toProjectAndRepositoryString(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }

    private static String pullRequestResourceId(int repositoryId, Long pullRequestId) {
        return repositoryId + ":" + pullRequestId;
    }

    private static String toJsonInternal(Object value) throws IOException {
        return objectMapperInstance.writeValueAsString(value);
    }
}

