/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;

public class AuditUtils {
    public static final String ATTRIBUTE_NAME_DETAILS = "details";
    public static final String ATTRIBUTE_NAME_TARGET = "target";
    public static final String AUDIT_RESOURCE_TYPE_PROJECT = "PROJECT";
    public static final String AUDIT_RESOURCE_TYPE_REPOSITORY = "REPOSITORY";
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();

    private AuditUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static ImmutableMap.Builder<String, Object> addProjectAndRepositoryToMap(@Nonnull Repository repository, ImmutableMap.Builder<String, Object> mapBuilder) {
        Objects.requireNonNull(repository, "repository");
        return mapBuilder.put((Object)"project", (Object)repository.getProject().getKey()).put((Object)"repository", (Object)repository.getSlug());
    }

    public static AuditAttribute attributeForDetails(String details) {
        return new AuditAttribute(ATTRIBUTE_NAME_DETAILS, details);
    }

    public static AuditAttribute attributeForTarget(String target) {
        return new AuditAttribute(ATTRIBUTE_NAME_TARGET, target);
    }

    public static AuditAuthor auditAuthorForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return new AuditAuthor.Builder().id(String.valueOf(user.getId())).name(user.getName()).type(user.getType().name()).build();
    }

    public static AuditResource auditResourceForProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return AuditResource.builder((String)project.getKey(), (String)AUDIT_RESOURCE_TYPE_PROJECT).id(String.valueOf(project.getId())).build();
    }

    public static AuditResource auditResourceForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return AuditResource.builder((String)repository.getSlug(), (String)AUDIT_RESOURCE_TYPE_REPOSITORY).id(String.valueOf(repository.getId())).build();
    }

    public static List<AuditResource> auditResourcesForProjectAndRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return ImmutableList.of((Object)AuditUtils.auditResourceForProject(repository.getProject()), (Object)AuditUtils.auditResourceForRepository(repository));
    }

    public static String toJSONString(@Nullable Map<String, Object> value) throws IOException {
        return AuditUtils.toJsonInternal(value);
    }

    public static String toJson(@Nullable Object value) {
        try {
            return AuditUtils.toJsonInternal(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert object %s to JSON", value), e);
        }
    }

    public static String toProjectAndRepositoryString(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }

    private static String toJsonInternal(Object value) throws IOException {
        return objectMapperInstance.writeValueAsString(value);
    }
}

