/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.FilePermission;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SetFilePermissionRequest {
    private final File file;
    private final Set<FilePermission> groupPermissions;
    private final Set<FilePermission> ownerPermissions;
    private final Set<FilePermission> worldPermissions;

    private SetFilePermissionRequest(@Nonnull Builder builder) {
        this.file = builder.file;
        this.groupPermissions = builder.groupPermissions.build();
        this.ownerPermissions = builder.ownerPermissions.build();
        this.worldPermissions = builder.worldPermissions.build();
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nonnull
    public Set<FilePermission> getGroupPermissions() {
        return this.groupPermissions;
    }

    @Nonnull
    public Set<FilePermission> getOwnerPermissions() {
        return this.ownerPermissions;
    }

    @Nonnull
    public Set<FilePermission> getWorldPermissions() {
        return this.worldPermissions;
    }

    public static class Builder
    extends BuilderSupport {
        private final File file;
        private final ImmutableSet.Builder<FilePermission> groupPermissions;
        private final ImmutableSet.Builder<FilePermission> ownerPermissions;
        private final ImmutableSet.Builder<FilePermission> worldPermissions;

        public Builder(@Nonnull File file) {
            this.file = Objects.requireNonNull(file, "file");
            this.groupPermissions = ImmutableSet.builder();
            this.ownerPermissions = ImmutableSet.builder();
            this.worldPermissions = ImmutableSet.builder();
        }

        @Nonnull
        public SetFilePermissionRequest build() {
            return new SetFilePermissionRequest(this);
        }

        @Nonnull
        public Builder groupPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.groupPermissions, (Object)((Object)permission));
            return this;
        }

        @Nonnull
        public Builder groupPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.groupPermissions, permissions);
            return this;
        }

        @Nonnull
        public Builder ownerPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.ownerPermissions, (Object)((Object)permission));
            return this;
        }

        @Nonnull
        public Builder ownerPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.ownerPermissions, permissions);
            return this;
        }

        @Nonnull
        public Builder worldPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.worldPermissions, (Object)((Object)permission));
            return this;
        }

        @Nonnull
        public Builder worldPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.worldPermissions, permissions);
            return this;
        }
    }
}

