/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Pattern FORMULA_PATTERN = Pattern.compile("[\\d\\+\\-\\*/\\(\\)\\s\\.]+");
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Properties loadFromFile(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                properties.load(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return properties;
    }

    public static void writeToFile(Properties properties, File file) throws IOException {
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        try {
            properties.store(os, null);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public static String getProperty(File file, String key) throws IOException {
        Properties props = PropertiesUtils.loadFromFile(file);
        return props.getProperty(key);
    }

    @Nonnull
    public static OptionalDouble parseExpressionAsDouble(@Nullable String expression) {
        return PropertiesUtils.parseExpression(expression, OptionalDouble::of, OptionalDouble::empty);
    }

    @Nonnull
    public static OptionalInt parseExpressionAsInt(@Nullable String expression) {
        OptionalLong longValue = PropertiesUtils.parseExpressionAsLong(expression);
        if (longValue.isPresent()) {
            return OptionalInt.of(Ints.saturatedCast((long)longValue.getAsLong()));
        }
        return OptionalInt.empty();
    }

    @Nonnull
    public static OptionalLong parseExpressionAsLong(@Nullable String expression) {
        return PropertiesUtils.parseExpression(expression, value -> OptionalLong.of(Math.round(value)), OptionalLong::empty);
    }

    @Nonnull
    private static <OV> OV parseExpression(@Nullable String expression, Function<Double, OV> toOptional, Supplier<OV> emptyOptional) {
        if (expression != null && FORMULA_PATTERN.matcher(expression = expression.toLowerCase().replace("cpu", Integer.toString(Runtime.getRuntime().availableProcessors()))).matches()) {
            try {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(expression, Double.TYPE, new String[0], new Class[0]);
                return (OV)toOptional.apply((Object)((Double)evaluator.evaluate(new Object[0])));
            }
            catch (CompileException e) {
                log.debug("Error while parsing expression " + expression, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug("Error while evaluating expression " + expression, (Throwable)e);
            }
        }
        return emptyOptional.get();
    }
}

